/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySeat;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockSeat
extends BlockTileEntity {
    public BlockSeat(String key, int id) {
        super(key, id, Material.wood);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        TileEntitySeat tileEntity;
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return false;
        }
        if (!world.isClientSide && (tileEntity = (TileEntitySeat)world.getBlockTileEntity(x, y, z)).getPassenger() == null) {
            player.startRiding(tileEntity);
        }
        return true;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntitySeat tileEntity;
        if (!world.isClientSide && (tileEntity = (TileEntitySeat)world.getBlockTileEntity(x, y, z)).getPassenger() != null) {
            tileEntity.ejectRider();
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntitySeat();
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(Item.seat)};
        }
        return null;
    }
}

