/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;

public class ItemStackJsonAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    @Override
    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Item item;
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("key")) {
            String key = obj.get("key").getAsString();
            try {
                if (key.startsWith("tile.")) {
                    item = Item.itemsList[Block.keyToIdMap.get(key)];
                }
                if (key.startsWith("item.")) {
                    item = Item.itemsList[Item.nameToIdMap.get(key)];
                }
                throw new IllegalArgumentException("Item keys must either start with 'tile' or 'item' provided key '" + key + "' does not!");
            }
            catch (Exception e) {
                System.out.println("Failed to find item for key '" + key + "'!");
                throw e;
            }
        } else {
            item = Item.itemsList[obj.get("id").getAsInt()];
        }
        ItemStack stack = obj.has("amount") ? new ItemStack(item, obj.get("amount").getAsInt(), obj.get("meta").getAsInt()) : new ItemStack(item, 1, obj.get("meta").getAsInt());
        return stack;
    }

    @Override
    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", src.itemID);
        obj.addProperty("amount", src.stackSize);
        obj.addProperty("meta", src.getMetadata());
        return obj;
    }
}

