/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemWandSpawner
extends Item {
    public ItemWandSpawner(String name, int id) {
        super(name, id);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.gamemode != Gamemode.creative) {
            entityplayer.sendTranslatedChatMessage("wand.wrongmode");
            return itemstack;
        }
        entityplayer.displayGUIWandMonsterPicker(itemstack);
        return itemstack;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (entityplayer.gamemode != Gamemode.creative) {
            entityplayer.sendTranslatedChatMessage("wand.wrongmode");
            return false;
        }
        if (!world.isClientSide) {
            Entity entity;
            String id = itemstack.getData().getString("monster");
            if (id == null || id.isEmpty()) {
                id = "Pig";
            }
            if ((entity = EntityDispatcher.createEntityInWorld(id, world)) != null) {
                entity.setPos((float)(blockX + side.getOffsetX()) + 0.5f, blockY + side.getOffsetY(), (float)(blockZ + side.getOffsetZ()) + 0.5f);
                entity.spawnInit();
                if (itemstack.hasCustomName() && entity instanceof EntityLiving) {
                    ((EntityLiving)entity).setNickname(itemstack.getCustomName());
                }
                world.entityJoinedWorld(entity);
            }
        }
        return true;
    }
}

