/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.util.helper.DamageType;
import org.jetbrains.annotations.Nullable;

public class InventoryPlayer
implements IInventory {
    public int hotbarOffset = 0;
    public ItemStack[] mainInventory = new ItemStack[36];
    public ItemStack[] armorInventory = new ItemStack[4];
    public int currentItem = 0;
    public EntityPlayer player;
    private ItemStack heldItem;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer player) {
        this.player = player;
    }

    @Nullable
    public ItemStack getCurrentItem() {
        if (this.currentItem < 9 + this.hotbarOffset && this.currentItem >= this.hotbarOffset) {
            return this.mainInventory[this.currentItem];
        }
        return null;
    }

    public static int func_25054_e() {
        return 36;
    }

    private int getInventorySlotContainItem(int i) {
        for (int j = 0; j < this.mainInventory.length; ++j) {
            if (this.mainInventory[j] == null || this.mainInventory[j].itemID != i) continue;
            return j;
        }
        return -1;
    }

    private int storeItemStack(ItemStack itemstack) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null || this.mainInventory[i].itemID != itemstack.itemID || !this.mainInventory[i].isStackable() || this.mainInventory[i].stackSize >= this.mainInventory[i].getMaxStackSize() || this.mainInventory[i].stackSize >= this.getInventoryStackLimit() || this.mainInventory[i].getHasSubtypes() && this.mainInventory[i].getMetadata() != itemstack.getMetadata()) continue;
            return i;
        }
        return -1;
    }

    public void insertItem(ItemStack stackToAdd, boolean useHotbarOffset) {
        if (!this.player.getGamemode().canInteract()) {
            return;
        }
        for (int stage = 0; stage < 2; ++stage) {
            for (int i = 0; i < this.mainInventory.length; ++i) {
                int transferAmount;
                int slotId = useHotbarOffset ? (i + this.hotbarOffset) % this.mainInventory.length : i;
                ItemStack stackInSlot = this.mainInventory[slotId];
                if (stage == 0) {
                    if (stackInSlot != null && stackInSlot.canStackWith(stackToAdd)) {
                        transferAmount = Math.min(stackToAdd.stackSize, stackInSlot.getMaxStackSize() - stackInSlot.stackSize);
                        if ((transferAmount = Math.min(transferAmount, stackToAdd.getMaxStackSize())) == 0) continue;
                        stackInSlot.stackSize += transferAmount;
                        stackToAdd.stackSize -= transferAmount;
                        stackInSlot.animationsToGo = 5;
                    }
                } else if (stage == 1 && stackInSlot == null) {
                    transferAmount = Math.min(stackToAdd.stackSize, stackToAdd.getMaxStackSize());
                    this.mainInventory[slotId] = stackToAdd.copy();
                    this.mainInventory[slotId].stackSize = transferAmount;
                    this.mainInventory[slotId].animationsToGo = 5;
                    stackToAdd.stackSize -= transferAmount;
                }
                if (stackToAdd.stackSize > 0) continue;
                return;
            }
        }
    }

    public int setCurrentItem(ItemStack itemstack, boolean flag) {
        if (!flag) {
            return this.currentItem;
        }
        if (itemstack.itemID < Block.blocksList.length ? Block.blocksList[itemstack.itemID].hasTag(BlockTags.NOT_IN_CREATIVE_MENU) : Item.itemsList[itemstack.itemID].hasTag(ItemTags.NOT_IN_CREATIVE_MENU)) {
            return this.currentItem;
        }
        for (int j = this.hotbarOffset; j < 9 + this.hotbarOffset; ++j) {
            if (this.mainInventory[j] == null || this.mainInventory[j].itemID != itemstack.itemID) continue;
            this.currentItem = j;
            return this.currentItem;
        }
        this.mainInventory[this.currentItem] = itemstack;
        return this.currentItem;
    }

    public void changeCurrentItem(int i) {
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        this.currentItem -= i;
        while (this.currentItem < this.hotbarOffset) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9 + this.hotbarOffset) {
            this.currentItem -= 9;
        }
    }

    public void decrementAnimations() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            this.mainInventory[i].updateAnimation(this.player.world, this.player, i, this.currentItem == i);
        }
    }

    public boolean consumeInventoryItem(int i) {
        int j = this.getInventorySlotContainItem(i);
        if (j < 0) {
            return false;
        }
        if (this.player.getGamemode().consumeBlocks() && --this.mainInventory[j].stackSize <= 0) {
            this.mainInventory[j] = null;
        }
        return true;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            i -= this.mainInventory.length;
        }
        if (aitemstack[i] != null) {
            if (aitemstack[i].stackSize <= j) {
                ItemStack itemstack = aitemstack[i];
                aitemstack[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i].splitStack(j);
            if (aitemstack[i].stackSize <= 0) {
                aitemstack[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        aitemstack[i] = itemstack;
    }

    public float getStrVsBlock(Block block) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(block);
        }
        return f;
    }

    public ListTag writeToNBT(ListTag nbttaglist) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putByte("Slot", (byte)i);
            this.mainInventory[i].writeToNBT(nbttagcompound);
            nbttaglist.addTag(nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)(j + 100));
            this.armorInventory[j].writeToNBT(nbttagcompound1);
            nbttaglist.addTag(nbttagcompound1);
        }
        return nbttaglist;
    }

    public void readFromNBT(ListTag nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound = (CompoundTag)nbttaglist.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.readItemStackFromNbt(nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.mainInventory.length) {
                this.mainInventory[j] = itemstack;
            }
            if (j < 100 || j >= this.armorInventory.length + 100) continue;
            this.armorInventory[j - 100] = itemstack;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        return aitemstack[i];
    }

    @Override
    public String getInvName() {
        return "Inventory";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int getDamageVsEntity(Entity entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(entity);
        }
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        if (block == null) {
            return false;
        }
        if (block.blockMaterial.isAlwaysDestroyable()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(block);
        }
        return false;
    }

    public ItemStack armorItemInSlot(int i) {
        return this.armorInventory[i];
    }

    public int getTotalArmourPoints() {
        float armorDurability = 0.0f;
        float maxDurability = 0.0f;
        for (int armorPiece = 0; armorPiece < this.armorInventory.length; ++armorPiece) {
            ItemStack itemStack = this.armorInventory[armorPiece];
            if (itemStack == null || !(itemStack.getItem() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)itemStack.getItem();
            maxDurability += (float)armor.getMaxDamage();
            armorDurability += (float)(armor.getMaxDamage() - itemStack.getMetadata());
        }
        return (int)(20.0f * (armorDurability / maxDurability));
    }

    public float getTotalProtectionAmount(DamageType damageType) {
        float protectionPercentage = 0.0f;
        for (int i = 0; i < this.armorInventory.length; ++i) {
            if (this.armorInventory[i] == null || !(this.armorInventory[i].getItem() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)this.armorInventory[i].getItem();
            protectionPercentage += armor.material.getProtection(damageType) * armor.getArmorPieceProtectionPercentage();
        }
        return protectionPercentage;
    }

    public void damageArmor(int damage) {
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null || !(this.armorInventory[j].getItem() instanceof ItemArmor)) continue;
            this.armorInventory[j].damageItem(damage, this.player);
            if (this.armorInventory[j].stackSize > 0) continue;
            this.armorInventory[j] = null;
        }
    }

    public void damageArmor(int damage, int armorSlot) {
        if (this.armorInventory[armorSlot] == null) {
            return;
        }
        this.armorInventory[armorSlot].damageItem(damage, this.player);
        if (this.armorInventory[armorSlot].stackSize <= 0) {
            this.armorInventory[armorSlot] = null;
        }
    }

    public void dropAllItems() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.mainInventory[i], true);
            this.mainInventory[i] = null;
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.armorInventory[j], true);
            this.armorInventory[j] = null;
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    public void setHeldItemStack(ItemStack itemstack) {
        this.heldItem = itemstack;
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.heldItem = null;
        }
        this.player.onItemStackChanged(itemstack);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.player.removed) {
            return false;
        }
        return entityplayer.distanceToSqr(this.player) <= 64.0;
    }

    public boolean func_28018_c(ItemStack itemstack) {
        for (int i = 0; i < this.armorInventory.length; ++i) {
            if (this.armorInventory[i] == null || !this.armorInventory[i].isStackEqual(itemstack)) continue;
            return true;
        }
        for (int j = 0; j < this.mainInventory.length; ++j) {
            if (this.mainInventory[j] == null || !this.mainInventory[j].isStackEqual(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sortInventory() {
        InventorySorter.sortInventory(this.mainInventory, 9, this.mainInventory.length - 1);
    }

    public void transferAllContents(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < this.mainInventory.length; ++i) {
            this.mainInventory[i] = inventoryPlayer.mainInventory[i];
            inventoryPlayer.mainInventory[i] = null;
        }
        for (i = 0; i < this.armorInventory.length; ++i) {
            this.armorInventory[i] = inventoryPlayer.armorInventory[i];
            inventoryPlayer.armorInventory[i] = null;
        }
    }
}

