/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.creative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.player.inventory.creative.CreativeTab;
import net.minecraft.core.player.inventory.creative.CreativeTabItemProvider;

public abstract class CreativeTabs {
    private static boolean initialized = false;
    private static final List<CreativeTab> tabList = new ArrayList<CreativeTab>();
    public static CreativeTab ALL;
    public static CreativeTab BLOCKS;
    public static CreativeTab ITEMS;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ALL = CreativeTabs.register("tab.creative.all", new ItemStack(Item.ammoSnowball), () -> {
            int i;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (i = 0; i < Item.highestItemId; ++i) {
                Item item = Item.itemsList[i];
                if (item == null || item.hasTag(ItemTags.NOT_IN_CREATIVE_MENU)) continue;
                items.add(new ItemStack(item));
            }
            for (i = 0; i < Block.highestBlockId; ++i) {
                Block block = Block.blocksList[i];
                if (block == null || block.hasTag(BlockTags.NOT_IN_CREATIVE_MENU)) continue;
                items.add(new ItemStack(block));
            }
            return items;
        });
        BLOCKS = CreativeTabs.register("tab.creative.blocks", new ItemStack(Block.grass), () -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < Block.highestBlockId; ++i) {
                Block block = Block.blocksList[i];
                if (block == null || block.hasTag(BlockTags.NOT_IN_CREATIVE_MENU)) continue;
                items.add(new ItemStack(block));
            }
            return items;
        });
        ITEMS = CreativeTabs.register("tab.creative.items", new ItemStack(Item.string), () -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < Item.highestItemId; ++i) {
                Item item = Item.itemsList[i];
                if (item == null || item.hasTag(ItemTags.NOT_IN_CREATIVE_MENU)) continue;
                items.add(new ItemStack(item));
            }
            return items;
        });
    }

    public static CreativeTab register(String translationKey, ItemStack icon, CreativeTabItemProvider itemProvider) {
        CreativeTab tab = new CreativeTab(translationKey, icon, itemProvider);
        tabList.add(tab);
        return tab;
    }

    public static List<CreativeTab> getTabList() {
        return Collections.unmodifiableList(tabList);
    }
}

