/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Block;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeBirchForest;
import net.minecraft.core.world.biome.BiomeBorealForest;
import net.minecraft.core.world.biome.BiomeCaatinga;
import net.minecraft.core.world.biome.BiomeDryForest;
import net.minecraft.core.world.biome.BiomeForest;
import net.minecraft.core.world.biome.BiomeNether;
import net.minecraft.core.world.biome.BiomeOutback;
import net.minecraft.core.world.biome.BiomeParadise;
import net.minecraft.core.world.biome.BiomePlains;
import net.minecraft.core.world.biome.BiomeRainforest;
import net.minecraft.core.world.biome.BiomeRetro;
import net.minecraft.core.world.biome.BiomeSeasonalForest;
import net.minecraft.core.world.biome.BiomeShrubland;
import net.minecraft.core.world.biome.BiomeSwamp;
import net.minecraft.core.world.biome.BiomeTaiga;
import net.minecraft.core.world.weather.Weather;

public class Biomes {
    public static final Biome OVERWORLD_RAINFOREST = Biomes.register("minecraft:overworld.rainforest", new BiomeRainforest("rainforest").setColor(1896704).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_SWAMPLAND = Biomes.register("minecraft:overworld.swampland", new BiomeSwamp("swampland").setColor(65400));
    public static final Biome OVERWORLD_SEASONAL_FOREST = Biomes.register("minecraft:overworld.seasonal_forest", new BiomeSeasonalForest("seasonal_forest").setColor(6606357));
    public static final Biome OVERWORLD_FOREST = Biomes.register("minecraft:overworld.forest", new BiomeForest("forest").setColor(2532885));
    public static final Biome OVERWORLD_GRASSLANDS = Biomes.register("minecraft:overworld.grasslands", new Biome("grasslands").setColor(15790152).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_OUTBACK = Biomes.register("minecraft:overworld.outback", new BiomeOutback("outback").setColor(14245408).setBlockedWeathers(Weather.overworldSnow).setTopBlock(Block.dirtScorched.id).setFillerBlock(Block.dirtScorched.id));
    public static final Biome OVERWORLD_SHRUBLAND = Biomes.register("minecraft:overworld.shrubland", new BiomeShrubland("shrubland").setColor(12237368));
    public static final Biome OVERWORLD_TAIGA = Biomes.register("minecraft:overworld.taiga", new BiomeTaiga("taiga").setColor(9092351).setSurfaceSnow());
    public static final Biome OVERWORLD_BOREAL_FOREST = Biomes.register("minecraft:overworld.boreal_forest", new BiomeBorealForest("boreal_forest").setColor(1344868));
    public static final Biome OVERWORLD_DESERT = Biomes.register("minecraft:overworld.desert", new Biome("desert").setColor(15589999).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm).setTopBlock(Block.sand.id).setFillerBlock(Block.sand.id));
    public static final Biome OVERWORLD_PLAINS = Biomes.register("minecraft:overworld.plains", new BiomePlains("plains").setColor(10733129));
    public static final Biome OVERWORLD_GLACIER = Biomes.register("minecraft:overworld.glacier", new Biome("glacier").setColor(13367039).setSurfaceSnow().setTopBlock(Block.blockSnow.id).setFillerBlock(Block.blockSnow.id));
    public static final Biome OVERWORLD_TUNDRA = Biomes.register("minecraft:overworld.tundra", new Biome("tundra").setColor(5759231).setSurfaceSnow());
    public static final Biome OVERWORLD_MEADOW = Biomes.register("minecraft:overworld.meadow", new BiomeBorealForest("meadow").setColor(0x8C8C22));
    public static final Biome NETHER_NETHER = Biomes.register("minecraft:nether.nether", new BiomeNether("nether").setColor(0xDD0000).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm, Weather.overworldFog));
    public static final Biome PARADISE_PARADISE = Biomes.register("minecraft:paradise.paradise", new BiomeParadise("paradise").setColor(0x8080FF).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm, Weather.overworldFog));
    public static final Biome OVERWORLD_BIRCH_FOREST = Biomes.register("minecraft:overworld.birch_forest", new BiomeBirchForest("birch_forest").setColor(4967262));
    public static final Biome OVERWORLD_RETRO = Biomes.register("minecraft:overworld.retro", new BiomeRetro("retro").setColor(7778634).setTopBlock(Block.grassRetro.id));
    public static final Biome OVERWORLD_HELL = Biomes.register("minecraft:overworld.hell", new Biome("hell").setColor(14246435).setTopBlock(Block.dirtScorched.id).setTopBlock(Block.dirtScorched.id));
    public static final Biome OVERWORLD_SWAMPLAND_MUDDY = Biomes.register("minecraft:overworld.swampland.muddy", new BiomeSwamp("swampland.muddy").setColor(5383936));
    public static final Biome OVERWORLD_OUTBACK_GRASSY = Biomes.register("minecraft:overworld.outback.grassy", new BiomeOutback("outback.grassy").setColor(15765559).setBlockedWeathers(Weather.overworldSnow).setTopBlock(Block.grassScorched.id).setFillerBlock(Block.dirtScorched.id));
    public static final Biome OVERWORLD_CAATINGA = Biomes.register("minecraft:overworld.caatinga", new BiomeCaatinga("caatinga").setColor(14601638).setTopBlock(Block.mudBaked.id).setFillerBlock(Block.mudBaked.id).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_CAATINGA_PLAINS = Biomes.register("minecraft:overworld.caatinga.plains", new Biome("caatinga.plains").setColor(10589303).setTopBlock(Block.mudBaked.id).setFillerBlock(Block.mudBaked.id).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_FOREST_DRY = Biomes.register("minecraft:overworld.forest.dry", new BiomeDryForest("forest.dry").setColor(8766578));

    public static Biome register(String key, Biome biome) {
        Registries.BIOMES.register(key, biome);
        return biome;
    }

    public static void init() {
    }
}

