/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.ArrayList;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeProcedural;

public class WorldFeatureThornTree
extends WorldFeatureSpoonerTreeProcedural {
    public WorldFeatureThornTree(int height, int trunkId, int trunkData, int leavesId, int leavesData) {
        super(height, trunkId, trunkData, leavesId, leavesData);
    }

    @Override
    protected void prepare(World world) {
        this.height += this.random.nextInt(3);
        this.foliageShape = new double[]{4.5, 3.5, 2.5, 1.5};
        this.branchSlope = 1.0;
        this.trunkRadius = 1.0;
        this.trunkHeight = (double)this.height * 0.9;
        this.branchDensity = BRANCH_DENSITY / FOLIAGE_DENSITY;
        int axis = this.random.nextInt(2);
        ArrayList<int[]> foliageCoords = new ArrayList<int[]>();
        int yStart = this.pos[1] + 1;
        int x = this.pos[0];
        int y = this.pos[1] + this.height + this.random.nextInt(3) + 3;
        int z = this.pos[2];
        int x1 = this.pos[0];
        int z1 = this.pos[2];
        int y1 = this.pos[1] + this.height + this.random.nextInt(3) + 3;
        Double shapefac = this.shapeFunc(y - yStart);
        double r = (Math.sqrt(this.random.nextDouble() * 2.0) + 0.125) * shapefac;
        double theta = this.random.nextDouble() * 2.0 * Math.PI;
        if (axis == 1) {
            x += (int)(r * Math.sin(theta));
            x1 -= (int)(r * Math.sin(theta));
        } else {
            z += (int)(r * Math.sin(theta));
            z1 -= (int)(r * Math.sin(theta));
        }
        foliageCoords.add(new int[]{x, y, z});
        foliageCoords.add(new int[]{x1, y1, z1});
        this.foliageCoords = foliageCoords;
    }

    @Override
    protected void makeBranches(World world) {
        int[] treePosition = this.pos;
        int topY = treePosition[1] + (int)(this.trunkHeight + 1.5);
        for (int[] coord : this.foliageCoords) {
            double dist = Math.sqrt(Math.pow(coord[0] - treePosition[0], 2.0) + Math.pow(coord[2] - treePosition[2], 2.0));
            int posY = coord[1];
            double slope = this.branchSlope + (0.5 - this.random.nextDouble()) * 0.16;
            double branchY = (double)coord[1] - dist * slope > (double)topY ? (double)topY : (double)posY - dist * slope;
            int[] startCoord = new int[]{treePosition[0], (int)branchY, treePosition[2]};
            this.taperedLimb(startCoord, coord, 1.0, 1.0, world);
        }
    }

    @Override
    protected Double shapeFunc(int y) {
        return (double)(this.height + 3) * 0.5;
    }
}

