/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree.spooner;

import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeProcedural;

public class WorldFeatureSpoonerTreeRound
extends WorldFeatureSpoonerTreeProcedural {
    public WorldFeatureSpoonerTreeRound(int height, int trunkId, int trunkData, int leavesId, int leavesData) {
        super(height, trunkId, trunkData, leavesId, leavesData);
    }

    @Override
    protected void prepare(World world) {
        super.prepare(world);
        this.branchSlope = 0.382;
        this.foliageShape = new double[]{2.0, 3.0, 3.0, 2.5, 1.6};
        this.trunkRadius *= 0.8;
        this.trunkHeight = TRUNK_HEIGHT * (double)this.height;
    }

    @Override
    protected Double shapeFunc(int y) {
        Double twigs = super.shapeFunc(y);
        if (twigs != null) {
            return twigs;
        }
        if ((double)y < (double)this.height * (0.282 + 0.1 * Math.sqrt(this.random.nextDouble()))) {
            return null;
        }
        double radius = (double)this.height / 2.0;
        double adj = (double)this.height / 2.0 - (double)y;
        double dist = adj == 0.0 ? radius : (Math.abs(adj) >= radius ? 0.0 : Math.sqrt(Math.pow(radius, 2.0) - Math.pow(adj, 2.0)));
        return dist *= 0.618;
    }
}

