/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.entity.player.EntityPlayer;

public class LevelData {
    private long randomSeed;
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long worldTime;
    private long lastTimePlayed;
    private long sizeOnDisk;
    private CompoundTag playerTag;
    private int dimension;
    private int gamemode;
    private String levelName;
    private int saveVersion;
    private boolean cheatsEnabled;
    private GameRuleCollection gameRules;

    public LevelData(CompoundTag tag) {
        this.readFromCompoundTag(tag);
    }

    public LevelData(long seed, String name) {
        this.randomSeed = seed;
        this.levelName = name;
        this.gameRules = new GameRuleCollection();
    }

    public LevelData(long seed, String name, GameRuleCollection gameRules) {
        this.randomSeed = seed;
        this.levelName = name;
        this.gameRules = gameRules;
    }

    public LevelData(LevelData levelData) {
        this.randomSeed = levelData.randomSeed;
        this.spawnX = levelData.spawnX;
        this.spawnY = levelData.spawnY;
        this.spawnZ = levelData.spawnZ;
        this.worldTime = levelData.worldTime;
        this.lastTimePlayed = levelData.lastTimePlayed;
        this.sizeOnDisk = levelData.sizeOnDisk;
        this.playerTag = levelData.playerTag;
        this.dimension = levelData.dimension;
        this.levelName = levelData.levelName;
        this.saveVersion = levelData.saveVersion;
        this.cheatsEnabled = levelData.cheatsEnabled;
        this.gamemode = levelData.gamemode;
        this.gameRules = levelData.gameRules.copy();
    }

    public LevelData(File worldDir) throws IOException {
        CompoundTag nbtRootData = null;
        if (!worldDir.exists()) {
            throw new IOException();
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
            nbtRootData = nbtRoot.getCompound("Data");
        } else {
            worldLevelDat = new File(worldDir, "level.dat_old");
            if (worldLevelDat.exists()) {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                nbtRootData = oldNbtRoot.getCompound("Data");
            }
        }
        if (nbtRootData == null) {
            throw new IOException();
        }
        this.readFromCompoundTag(nbtRootData);
        if (this.gameRules == null) {
            this.gameRules = new GameRuleCollection();
        }
    }

    public CompoundTag getNBTTagCompound() {
        CompoundTag nbttagcompound = new CompoundTag();
        this.updateTagCompound(nbttagcompound, this.playerTag);
        return nbttagcompound;
    }

    public CompoundTag getNBTTagCompoundWithPlayer(List<EntityPlayer> list) {
        CompoundTag nbttagcompound = new CompoundTag();
        EntityPlayer entityplayer = null;
        CompoundTag nbttagcompound1 = null;
        if (list.size() > 0) {
            entityplayer = list.get(0);
        }
        if (entityplayer != null) {
            nbttagcompound1 = new CompoundTag();
            entityplayer.saveWithoutId(nbttagcompound1);
        }
        this.updateTagCompound(nbttagcompound, nbttagcompound1);
        return nbttagcompound;
    }

    private void updateTagCompound(CompoundTag levelTag, CompoundTag playerTag) {
        levelTag.putLong("RandomSeed", this.randomSeed);
        levelTag.putInt("SpawnX", this.spawnX);
        levelTag.putInt("SpawnY", this.spawnY);
        levelTag.putInt("SpawnZ", this.spawnZ);
        levelTag.putLong("Time", this.worldTime);
        levelTag.putLong("SizeOnDisk", this.sizeOnDisk);
        levelTag.putLong("LastPlayed", System.currentTimeMillis());
        levelTag.putString("LevelName", this.levelName);
        levelTag.putInt("version", this.saveVersion);
        levelTag.putBoolean("CheatsEnabled", this.cheatsEnabled);
        if (playerTag != null) {
            levelTag.putCompound("Player", playerTag);
        }
        CompoundTag gameRulesTag = new CompoundTag();
        GameRuleCollection.writeToNBT(gameRulesTag, this.gameRules);
        levelTag.put("GameRules", gameRulesTag);
    }

    private void readFromCompoundTag(CompoundTag tag) {
        this.randomSeed = tag.getLong("RandomSeed");
        this.spawnX = tag.getInteger("SpawnX");
        this.spawnY = tag.getInteger("SpawnY");
        this.spawnZ = tag.getInteger("SpawnZ");
        this.worldTime = tag.getLong("Time");
        this.lastTimePlayed = tag.getLong("LastPlayed");
        this.sizeOnDisk = tag.getLong("SizeOnDisk");
        this.levelName = tag.getString("LevelName");
        this.saveVersion = tag.getInteger("version");
        this.cheatsEnabled = tag.getBoolean("CheatsEnabled");
        if (tag.containsKey("Player")) {
            this.playerTag = tag.getCompound("Player");
            this.dimension = this.playerTag.getInteger("Dimension");
            this.gamemode = this.playerTag.getInteger("Gamemode");
        }
        if (tag.containsKey("GameRules")) {
            CompoundTag gameRulesTag = tag.getCompound("GameRules");
            this.gameRules = GameRuleCollection.readFromNBT(gameRulesTag);
        } else {
            this.gameRules = new GameRuleCollection();
        }
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public int getSpawnY() {
        return this.spawnY;
    }

    public int getSpawnZ() {
        return this.spawnZ;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public CompoundTag getPlayerNBTTagCompound() {
        return this.playerTag;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setSpawnX(int i) {
        this.spawnX = i;
    }

    public void setSpawnY(int i) {
        this.spawnY = i;
    }

    public void setSpawnZ(int i) {
        this.spawnZ = i;
    }

    public void setWorldTime(long l) {
        this.worldTime = l;
    }

    public void setSizeOnDisk(long l) {
        this.sizeOnDisk = l;
    }

    public void setPlayerNBTTagCompound(CompoundTag nbttagcompound) {
        this.playerTag = nbttagcompound;
    }

    public void setSpawn(int i, int j, int k) {
        this.spawnX = i;
        this.spawnY = j;
        this.spawnZ = k;
    }

    public String getWorldName() {
        return this.levelName;
    }

    public void setWorldName(String s) {
        this.levelName = s;
    }

    public int getSaveVersion() {
        return this.saveVersion;
    }

    public void setSaveVersion(int i) {
        this.saveVersion = i;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public GameRuleCollection getGameRules() {
        return this.gameRules;
    }

    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean enabled) {
        this.cheatsEnabled = enabled;
    }
}

