/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class EntityDiggingFX
extends EntityFX {
    private Block block;
    private Side side;

    public EntityDiggingFX(World world, double d, double d1, double d2, double d3, double d4, double d5, Block block, int i, int meta) {
        super(world, d, d1, d2, d3, d4, d5);
        this.side = Side.getSideById(i);
        this.block = block;
        this.particleTexture = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getParticleTexture(this.side, meta);
        this.particleGravity = block != null ? block.blockParticleGravity : 0.0f;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale /= 2.0f;
    }

    public EntityDiggingFX setParticleColor(int x, int y, int z) {
        int meta = this.world.getBlockMetadata(x, y, z);
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        if (model.shouldSideBeColored(this.world, x, y, z, this.side.getId(), meta)) {
            int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(this.world, x, y, z);
            this.particleRed *= (float)(l >> 16 & 0xFF) / 255.0f;
            this.particleGreen *= (float)(l >> 8 & 0xFF) / 255.0f;
            this.particleBlue *= (float)(l & 0xFF) / 255.0f;
        }
        return this;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        if (this.particleTexture == null) {
            return;
        }
        float f6 = (float)this.particleTexture.getSubIconU(this.particleTextureJitterX / 4.0f);
        float f7 = (float)this.particleTexture.getSubIconU(0.25f + this.particleTextureJitterX / 4.0f);
        float f8 = (float)this.particleTexture.getSubIconV(this.particleTextureJitterX / 4.0f);
        float f9 = (float)this.particleTexture.getSubIconV(0.25f + this.particleTextureJitterX / 4.0f);
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)partialTick - lerpPosX);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)partialTick - lerpPosY);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)partialTick - lerpPosZ);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            brightness = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(brightness * this.particleRed, brightness * this.particleGreen, brightness * this.particleBlue);
        t.addVertexWithUV(f11 - rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 - rotationZ * f10 - rotationXY * f10, f6, f9);
        t.addVertexWithUV(f11 - rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 - rotationZ * f10 + rotationXY * f10, f6, f8);
        t.addVertexWithUV(f11 + rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 + rotationZ * f10 + rotationXY * f10, f7, f8);
        t.addVertexWithUV(f11 + rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 + rotationZ * f10 - rotationXY * f10, f7, f9);
    }
}

