/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.lang.text.Text;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class Gui {
    public float zLevel = 0.0f;

    protected void drawLineHorizontal(int minX, int maxX, int minY, int argb) {
        if (maxX < minX) {
            int temp = minX;
            minX = maxX;
            maxX = temp;
        }
        this.drawRect(minX, minY, maxX + 1, minY + 1, argb);
    }

    protected void drawLineVertical(int minX, int minY, int maxY, int argb) {
        if (maxY < minY) {
            int temp = minY;
            minY = maxY;
            maxY = temp;
        }
        this.drawRect(minX, minY + 1, minX + 1, maxY, argb);
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        int temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected void drawBox(int minX, int minY, int maxX, int maxY, int argb, int lineThickness) {
        this.drawRect(minX, minY, maxX, minY + lineThickness, argb);
        this.drawRect(minX, maxY - lineThickness, maxX, maxY, argb);
        this.drawRect(minX, minY + lineThickness, minX + lineThickness, maxY - lineThickness, argb);
        this.drawRect(maxX - lineThickness, minY + lineThickness, maxX, maxY - lineThickness, argb);
    }

    protected void drawRectNoBlend(int minX, int minY, int maxX, int maxY, int argb) {
        int temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    protected void drawRectWidthHeight(int x, int y, int width, int height, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb >> 0 & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x, y + height, 0.0);
        tessellator.addVertex(x + width, y + height, 0.0);
        tessellator.addVertex(x + width, y, 0.0);
        tessellator.draw();
    }

    protected void drawGradientRect(int minX, int minY, int maxX, int maxY, int argb1, int argb2) {
        float a1 = (float)(argb1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(argb1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(argb1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(argb1 & 0xFF) / 255.0f;
        float a2 = (float)(argb2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(argb2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(argb2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(argb2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r1, g1, b1, a1);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.setColorRGBA_F(r2, g2, b2, a2);
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void drawTextCentered(FontRenderer fr, Text text, int x, int y, int argb) {
        fr.drawTextWithShadow(text, x - fr.getTextWidth(text) / 2, y, argb);
    }

    public void drawTextCenteredNoShadow(FontRenderer fr, Text text, int x, int y, int argb) {
        fr.drawText(text, x - fr.getTextWidth(text) / 2, y, argb);
    }

    public void drawText(FontRenderer fr, Text text, int x, int y, int argb) {
        fr.drawTextWithShadow(text, x, y, argb);
    }

    public void drawTextNoShadow(FontRenderer fr, Text text, int x, int y, int argb) {
        fr.drawText(text, x, y, argb);
    }

    public void drawStringCentered(FontRenderer fr, String string, int x, int y, int argb) {
        fr.drawStringWithShadow(string, x - fr.getStringWidth(string) / 2, y, argb);
    }

    public void drawStringCenteredNoShadow(FontRenderer fr, String string, int x, int y, int argb) {
        fr.drawString(string, x - fr.getStringWidth(string) / 2, y, argb);
    }

    public void drawString(FontRenderer fr, String string, int x, int y, int argb) {
        fr.drawStringWithShadow(string, x, y, argb);
    }

    public void drawStringNoShadow(FontRenderer fr, String string, int x, int y, int argb) {
        fr.drawString(string, x, y, argb);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.zLevel, (float)(u + 0) * uScale, (float)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (float)(u + width) * uScale, (float)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width, y + 0, this.zLevel, (float)(u + width) * uScale, (float)(v + 0) * vScale);
        tessellator.addVertexWithUV(x + 0, y + 0, this.zLevel, (float)(u + 0) * uScale, (float)(v + 0) * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double uScale, double vScale) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.zLevel, (double)(u + 0) * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (double)(u + width) * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width, y + 0, this.zLevel, (double)(u + width) * uScale, (double)(v + 0) * vScale);
        tessellator.addVertexWithUV(x + 0, y + 0, this.zLevel, (double)(u + 0) * uScale, (double)(v + 0) * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRect(double x, double y, int u, int v, int width, int height, int uvWidth, int uvHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + (double)height, this.zLevel, (float)(u + 0) * uScale, (float)(v + uvHeight) * vScale);
        tessellator.addVertexWithUV(x + (double)width, y + (double)height, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + uvHeight) * vScale);
        tessellator.addVertexWithUV(x + (double)width, y + 0.0, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + 0) * vScale);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, (float)(u + 0) * uScale, (float)(v + 0) * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int uvWidth, float scale) {
        float uScale = scale;
        float vScale = scale;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.zLevel, (float)(u + 0) * uScale, (float)(v + uvWidth) * vScale);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + uvWidth) * vScale);
        tessellator.addVertexWithUV(x + width, y + 0, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + 0) * vScale);
        tessellator.addVertexWithUV(x + 0, y + 0, this.zLevel, (float)(u + 0) * uScale, (float)(v + 0) * vScale);
        tessellator.draw();
    }

    public void drawTexturedIcon(int x, int y, int width, int height, IconCoordinate coordinate) {
        coordinate.parentAtlas.bindTexture();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y + 0, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x + 0, y + 0, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.draw();
    }

    public void drawSlot(RenderEngine re, int x, int y, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        re.bindTexture(re.getTexture("/assets/minecraft/textures/gui/slot.png"));
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.drawTexturedModalRect(x, y, 0, 0, 18, 18, 18, 0.0078125f);
    }
}

