/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiClickableLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiMissingMinecraft
extends GuiScreen {
    public int ticks = 0;

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.controlList.clear();
        String downloadString = i.translateKey("gui.no_minecraft.button.guide");
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, i.translateKey("gui.no_minecraft.button.quit")));
        GuiClickableLabel installLabel = new GuiClickableLabel(1, this.width / 2 - 170, this.height / 4 - 60 + 60 + 64, downloadString, 8165866);
        this.controlList.add(installLabel);
        this.controlList.add(new GuiClickableLabel(2, 0, this.height - this.fontRenderer.fontHeight - 4, i.translateKey("gui.main_menu.button.discord"), 5793266));
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        I18n i = I18n.getInstance();
        this.drawBackground(partialTick);
        this.drawStringCentered(this.fontRenderer, i.translateKey("gui.no_minecraft.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFF60);
        this.drawString(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.1"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 0, 0xDEDEDE);
        this.drawString(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 18, 0xDEDEDE);
        this.drawString(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.3"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 27, 0xDEDEDE);
        this.drawString(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.4"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 45, 0xDEDEDE);
        this.drawString(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.5"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 54, 0xDEDEDE);
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        Desktop desktop;
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.shutdown();
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            if (button.id == 1) {
                try {
                    desktop.browse(URI.create("https://www.betterthanadventure.net/installation-guide/"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (button.id == 2) {
                try {
                    desktop.browse(URI.create("https://betterthanadventure.net/discord"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void tick() {
        ++this.ticks;
    }

    public void drawBackground(float partialTick) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/assets/minecraft/textures/block/netherrack_mossy.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/assets/minecraft/textures/block/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(0.2509804f, 0.2509804f, 0.2509804f, MathHelper.clamp(1.0f - ((float)this.ticks + partialTick) / 80000.0f, 0.0f, 1.0f));
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        this.drawGradientRect(0, 0, this.width, this.height, 0x22402020, -11530224);
    }
}

