/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.render.FontRenderer;
import org.lwjgl.opengl.GL11;

public class GuiSwitchButton
extends GuiButton {
    private final String onText;
    private final String offText;
    private boolean on;

    public GuiSwitchButton(int id, int xPosition, int yPosition, boolean on, String onText, String offText) {
        super(id, xPosition, yPosition, "");
        this.on = on;
        this.onText = onText;
        this.offText = offText;
        this.updateText();
    }

    public GuiSwitchButton(int id, int xPosition, int yPosition, int width, int height, boolean on, String onText, String offText) {
        super(id, xPosition, yPosition, width, height, "");
        this.on = on;
        this.onText = onText;
        this.offText = offText;
        this.updateText();
    }

    private void updateText() {
        this.displayString = this.on ? this.onText : this.offText;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
        this.updateText();
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.fontRenderer;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        int xBar = this.on ? this.width / 3 : 0;
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + xBar, this.yPosition, 0, 46 + state * 20, this.width / 3, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 3 + xBar, this.yPosition, 200 - this.width / 3, 46 + state * 20, this.width / 3, this.height);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + xBar + this.width / 3, this.yPosition + (this.height - 8) / 2, textColor);
    }
}

