/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import net.minecraft.core.block.material.Material;
import org.lwjgl.opengl.GL11;

public class OxygenBarComponent
extends MovableHudComponent {
    public OxygenBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.gameSettings.immersiveMode.drawHotbar() && mc.playerController.canHurtPlayer() && !mc.thePlayer.getGamemode().isPlayerInvulnerable() && mc.thePlayer.isUnderLiquid(Material.water);
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int numBubbles = (int)Math.ceil((double)(mc.thePlayer.airSupply - 2) * 10.0 / 300.0);
        int numPops = (int)Math.ceil((double)mc.thePlayer.airSupply * 10.0 / 300.0) - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                gui.drawTexturedModalRect(x + i * 8, y, 16, 18, 9, 9);
                continue;
            }
            gui.drawTexturedModalRect(x + i * 8, y, 25, 18, 9, 9);
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int numBubbles = 5;
        int numPops = 6 - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                gui.drawTexturedModalRect(x + i * 8, y, 16, 18, 9, 9);
                continue;
            }
            gui.drawTexturedModalRect(x + i * 8, y, 25, 18, 9, 9);
        }
    }
}

