/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.world.World;

public class EntityFallingSandEntry
extends EntityEntry<EntityFallingSand> {
    @Override
    public void onTick(EntityFallingSand entity) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, final EntityFallingSand sand) {
        final GuiTextCycle<Integer> blockIdCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, 0, 120, 20, Integer.valueOf(sand.blockID)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return GuiModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    if (Block.blocksList[id] != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return sand.blockID;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        blockIdCycle.textField.setPrefaceText("ID: ");
        blockIdCycle.textField.setPlaceholder("Block ID");
        blockIdCycle.setOnValueChanged(() -> {
            sand.blockID = (Integer)blockIdCycle.getCurrentElement();
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(blockIdCycle);
            }
        };
    }

    @Override
    public EntityFallingSand getEntityInstance(Minecraft mc, World world) {
        return new EntityFallingSand(world);
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

