/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.modelviewer.elements.IActionListener;
import net.minecraft.client.gui.modelviewer.elements.IKeyListener;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.option.FloatOption;

public class GuiListenerSlider
extends GuiSlider
implements IListenerElement {
    private IActionListener action;
    private IKeyListener keyListener;
    private Runnable onValueChanged;

    public GuiListenerSlider(int id, int xPosition, int yPosition, FloatOption floatOption) {
        super(id, xPosition, yPosition, floatOption);
    }

    public GuiListenerSlider(int id, int xPosition, int yPosition, int width, int height, FloatOption floatOption) {
        super(id, xPosition, yPosition, width, height, floatOption);
    }

    public GuiListenerSlider(int id, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id, xPosition, yPosition, width, height, text, defaultValue);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        float _val = this.sliderValue;
        boolean flag = super.mouseClicked(mc, mouseX, mouseY);
        if (flag && this.action != null) {
            this.action.onInteract();
            if (this.sliderValue != _val) {
                this.onValueChanged();
            }
        }
        return flag;
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        float _val = this.sliderValue;
        super.mouseDragged(mc, mouseX, mouseY);
        if (this.sliderValue != _val) {
            this.onValueChanged();
        }
    }

    @Override
    public void setActionListener(IActionListener listener) {
        this.action = listener;
    }

    @Override
    public void setKeyListener(IKeyListener listener) {
        this.keyListener = listener;
    }

    @Override
    public void setOnValueChanged(Runnable runnable) {
        this.onValueChanged = runnable;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (this.keyListener != null) {
            this.keyListener.onKeyPressed(key);
        }
    }

    @Override
    public void onValueChanged() {
        if (this.onValueChanged != null) {
            this.onValueChanged.run();
        }
    }
}

