/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import java.net.ConnectException;
import java.net.UnknownHostException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConnectFailed;
import net.minecraft.client.gui.GuiConnecting;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.core.net.packet.Packet2Handshake;

public class ThreadConnectToServer
extends Thread {
    final Minecraft mc;
    final String hostName;
    final int port;
    final GuiConnecting connectingGui;

    public ThreadConnectToServer(GuiConnecting guiconnecting, Minecraft minecraft, String s, int i) {
        this.connectingGui = guiconnecting;
        this.mc = minecraft;
        this.hostName = s;
        this.port = i;
    }

    @Override
    public void run() {
        try {
            GuiConnecting.setNetClientHandler(this.connectingGui, new NetClientHandler(this.mc, this.hostName, this.port));
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            GuiConnecting.getNetClientHandler(this.connectingGui).addToSendQueue(new Packet2Handshake(this.mc.session.username));
        }
        catch (UnknownHostException unknownhostexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{"Unknown host '" + this.hostName + "'"}));
        }
        catch (ConnectException connectexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{connectexception.getMessage()}));
        }
        catch (Exception exception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            exception.printStackTrace();
            this.mc.displayGuiScreen(new GuiConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{exception.toString()}));
        }
    }
}

