/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public abstract class BlockModel<T extends Block> {
    public static RenderBlocks renderBlocks;
    public final T block;
    protected boolean hasOverbright = false;

    public BlockModel(Block block) {
        this.block = block;
    }

    public abstract boolean render(Tessellator var1, int var2, int var3, int var4);

    public boolean renderNoCulling(Tessellator tessellator, int x, int y, int z) {
        BlockModel.renderBlocks.renderAllFaces = true;
        boolean result = this.render(tessellator, x, y, z);
        BlockModel.renderBlocks.renderAllFaces = false;
        return result;
    }

    public boolean renderWithOverrideTexture(Tessellator tessellator, int x, int y, int z, IconCoordinate textureIndex) {
        BlockModel.renderBlocks.overrideBlockTexture = textureIndex;
        boolean result = this.render(tessellator, x, y, z);
        BlockModel.renderBlocks.overrideBlockTexture = null;
        return result;
    }

    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness) {
        this.renderBlockOnInventory(tessellator, metadata, brightness, 1.0f);
    }

    public abstract void renderBlockOnInventory(Tessellator var1, int var2, float var3, float var4);

    public abstract boolean shouldItemRender3d();

    public abstract float getItemRenderScale();

    public abstract IconCoordinate getBlockTexture(WorldSource var1, int var2, int var3, int var4, Side var5);

    public abstract IconCoordinate getBlockOverbrightTexture(WorldSource var1, int var2, int var3, int var4, int var5);

    public abstract IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side var1, int var2);

    public abstract IconCoordinate getBlockTextureFromSideAndMetadata(Side var1, int var2);

    public abstract IconCoordinate getParticleTexture(Side var1, int var2);

    public abstract boolean shouldSideBeRendered(WorldSource var1, int var2, int var3, int var4, int var5, int var6);

    public abstract boolean shouldSideBeRendered(WorldSource var1, int var2, int var3, int var4, int var5);

    public abstract boolean shouldSideBeColored(WorldSource var1, int var2, int var3, int var4, int var5, int var6);

    public void setBlockBoundsForItemRender() {
    }

    public boolean hasOverbright() {
        return this.hasOverbright;
    }

    public static void setRenderBlocks(RenderBlocks rb) {
        renderBlocks = rb;
    }

    public void resetRenderBlocks() {
        BlockModel.renderBlocks.renderAllFaces = false;
        BlockModel.renderBlocks.enableAO = false;
        BlockModel.renderBlocks.overbright = false;
        BlockModel.renderBlocks.useInventoryTint = true;
        BlockModel.renderBlocks.flipTexture = false;
        BlockModel.renderBlocks.overrideBlockTexture = null;
        BlockModel.renderBlocks.uvRotateEast = 0;
        BlockModel.renderBlocks.uvRotateWest = 0;
        BlockModel.renderBlocks.uvRotateSouth = 0;
        BlockModel.renderBlocks.uvRotateNorth = 0;
        BlockModel.renderBlocks.uvRotateTop = 0;
        BlockModel.renderBlocks.uvRotateBottom = 0;
        BlockModel.renderBlocks.field_22352_G = 1;
        BlockModel.renderBlocks.renderBitMask = 0;
    }

    public void setRenderSide(Side side, boolean shouldRender) {
        BlockModel.renderBlocks.renderBitMask = !shouldRender ? (byte)(BlockModel.renderBlocks.renderBitMask | (byte)(1 << side.getId())) : (byte)(BlockModel.renderBlocks.renderBitMask & (byte)(~(1 << side.getId())));
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return renderBlocks.getBlockBrightness(blockAccess, x, y, z);
    }

    public final boolean renderStandardBlock(Tessellator tessellator, Block block, int x, int y, int z) {
        return renderBlocks.renderStandardBlock(tessellator, this, block, x, y, z);
    }

    public final boolean renderStandardBlock(Tessellator tessellator, Block block, int x, int y, int z, float r, float g, float b) {
        return renderBlocks.renderStandardBlock(tessellator, this, block, x, y, z, r, g, b);
    }

    public final boolean renderSide(Tessellator tessellator, Block block, int x, int y, int z, Side side, int meta) {
        return renderBlocks.renderSide(tessellator, this, block, x, y, z, 1.0f, 1.0f, 1.0f, side, meta);
    }

    public final boolean renderSide(Tessellator tessellator, Block block, int x, int y, int z, float r, float g, float b, Side side, int meta) {
        return renderBlocks.renderSide(tessellator, this, block, x, y, z, r, g, b, side, meta);
    }

    public final boolean renderSide(Tessellator tessellator, Block block, int x, int y, int z, float r, float g, float b, int side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        return renderBlocks.renderSide(tessellator, this, block, x, y, z, r, g, b, side, meta, dirX, dirY, dirZ, depth, topX, topY, topZ, topP, botP, lefX, lefY, lefZ, lefP, rigP);
    }

    public final void renderBottomFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderBottomFace(tessellator, block, x, y, z, tex);
    }

    public final void renderTopFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderTopFace(tessellator, block, x, y, z, tex);
    }

    public final void renderNorthFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderNorthFace(tessellator, block, x, y, z, tex);
    }

    public final void renderSouthFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderSouthFace(tessellator, block, x, y, z, tex);
    }

    public final void renderWestFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderWestFace(tessellator, block, x, y, z, tex);
    }

    public final void renderEastFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        renderBlocks.renderEastFace(tessellator, block, x, y, z, tex);
    }
}

