/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import org.lwjgl.opengl.GL11;

public class BlockModelCactus<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelCactus(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelCactus.renderBlocks.blockAccess, x, y, z);
        float sidesOffset = 0.0625f;
        this.block.setBlockBounds(0.0625, 0.0, 0.0, 0.9375, 1.0, 1.0);
        this.setRenderSide(Side.SOUTH, false);
        this.setRenderSide(Side.NORTH, false);
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        BlockModelCactus.renderBlocks.renderBitMask = (byte)63;
        this.block.setBlockBounds(0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375);
        this.setRenderSide(Side.SOUTH, true);
        this.setRenderSide(Side.NORTH, true);
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        BlockModelCactus.renderBlocks.renderBitMask = 0;
        this.block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        if (BlockModelCactus.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        }
        this.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float sidesOffset = 0.0625f;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.offsetTranslation(0.0f, 0.0f, 0.0625f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.offsetTranslation(0.0f, 0.0f, -0.0625f);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.offsetTranslation(0.0f, 0.0f, -0.0625f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.offsetTranslation(0.0f, 0.0f, 0.0625f);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.offsetTranslation(0.0625f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.offsetTranslation(-0.0625f, 0.0f, 0.0f);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.offsetTranslation(-0.0625f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.offsetTranslation(0.0625f, 0.0f, 0.0f);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

