/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelDoor;
import net.minecraft.client.render.block.model.BlockModelTrapDoorPainted;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockDoor;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.util.helper.Side;

public class BlockModelDoorPainted<T extends BlockDoor>
extends BlockModelDoor<T> {
    public static final IconCoordinate[] doorBottomTextures = new IconCoordinate[16];
    public static final IconCoordinate[] doorTopTextures = new IconCoordinate[16];
    private final boolean isTop;

    public BlockModelDoorPainted(Block block, boolean isTop) {
        super(block);
        this.isTop = isTop;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int sideId = side.getId();
        int color = data >> 4 & 0xF;
        if (sideId < 2) {
            return BlockModelTrapDoorPainted.topTextures[color];
        }
        if (this.isTop) {
            return doorTopTextures[color];
        }
        return doorBottomTextures[color];
    }

    static {
        for (int i = 0; i < 16; ++i) {
            BlockModelDoorPainted.doorTopTextures[i] = TextureRegistry.getTexture("minecraft:block/door_planks_oak_" + ItemDye.dyeColors[15 - i] + "_top");
            BlockModelDoorPainted.doorBottomTextures[i] = TextureRegistry.getTexture("minecraft:block/door_planks_oak_" + ItemDye.dyeColors[15 - i] + "_bottom");
        }
    }
}

