/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import org.lwjgl.opengl.GL11;

public class BlockModelLeavesOverlay<T extends Block>
extends BlockModelLeaves<T> {
    protected final IconCoordinate overlayTexture;

    public BlockModelLeavesOverlay(Block block, String leavesTex, String overlayTex) {
        super(block, leavesTex);
        this.overlayTexture = TextureRegistry.getTexture(overlayTex);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        super.render(tessellator, x, y, z);
        BlockModelLeavesOverlay.renderBlocks.overrideBlockTexture = this.overlayTexture;
        this.renderStandardBlock(tessellator, this.block, x, y, z, 1.0f, 1.0f, 1.0f);
        BlockModelLeavesOverlay.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        IconCoordinate overlayCoord = this.overlayTexture;
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

