/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import net.minecraft.client.render.colorizer.Colorizer;
import net.minecraft.core.util.helper.MathHelper;

public class ColorMap {
    public final Colorizer colorizer;
    public final int[] buffer = new int[65536];

    public ColorMap(Colorizer colorizer) {
        this.colorizer = colorizer;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = -1;
        }
    }

    public int getColor(double temp, double humid) {
        temp = MathHelper.clamp(temp, 0.0, 1.0);
        humid = MathHelper.clamp(humid, 0.0, 1.0);
        int x = (int)((1.0 - temp) * 255.0);
        int y = (int)((1.0 - (humid *= temp)) * 255.0);
        return this.buffer[y << 8 | x];
    }
}

