/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.colorizer.ColorMap;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class Colorizer {
    public final String name;
    private ColorMap defaultColor;
    private Map<Season, ColorMap> seasonalColormaps;
    private ColorMap currentColor;
    private boolean enabled = false;

    public Colorizer(String name) {
        this.name = name;
    }

    public void setup(Minecraft minecraft, List<Season> seasons) {
        this.defaultColor = new ColorMap(this);
        this.seasonalColormaps = new HashMap<Season, ColorMap>();
        this.currentColor = new ColorMap(this);
        if (Colorizers.loadColorData(this.defaultColor, "default")) {
            this.enabled = true;
            for (int i = 0; i < seasons.size(); ++i) {
                String seasonName;
                ColorMap colorMap;
                Season season = seasons.get(i);
                if (season == Seasons.NULL || !Colorizers.loadColorData(colorMap = new ColorMap(this), seasonName = season.getId().replace('.', '_'))) continue;
                this.seasonalColormaps.put(season, colorMap);
            }
        } else {
            this.enabled = false;
        }
    }

    public ColorMap getColormapForSeason(Season season) {
        ColorMap colorMap = this.seasonalColormaps.get(season);
        if (colorMap == null) {
            return this.defaultColor;
        }
        return colorMap;
    }

    public void update(Season season) {
        ColorMap seasonColors = this.getColormapForSeason(season);
        for (int i = 0; i < this.currentColor.buffer.length; ++i) {
            this.currentColor.buffer[i] = seasonColors.buffer[i];
        }
    }

    public void update(Season season1, Season season2, float blendFactor) {
        ColorMap seasonColors1 = this.getColormapForSeason(season1);
        ColorMap seasonColors2 = this.getColormapForSeason(season2);
        for (int i = 0; i < this.currentColor.buffer.length; ++i) {
            this.currentColor.buffer[i] = Colorizer.blendColor(seasonColors1.buffer[i], seasonColors2.buffer[i], blendFactor);
        }
    }

    public int getDefaultColor(double temperature, double humidity) {
        if (!this.enabled) {
            return -1;
        }
        return this.defaultColor.getColor(temperature, humidity);
    }

    public int getColor(WorldSource world, int x, int y, int z) {
        if (!this.enabled) {
            return -1;
        }
        double temperature = world.getBlockTemperature(x, z);
        double humidity = world.getBlockHumidity(x, z);
        return this.getColor(temperature, humidity);
    }

    public int getColor(double temperature, double humidity) {
        if (!this.enabled) {
            return -1;
        }
        return this.currentColor.getColor(temperature, humidity);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static int blendColor(int color1, int color2, float blend) {
        float blend1 = 1.0f - blend;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 >> 0 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 >> 0 & 0xFF;
        int r = (int)((float)r1 * blend1 + (float)r2 * blend);
        int g = (int)((float)g1 * blend1 + (float)g2 * blend);
        int b = (int)((float)b1 * blend1 + (float)b2 * blend);
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        return r << 16 | g << 8 | b;
    }
}

