/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.colorizer.ColorMap;
import net.minecraft.client.render.colorizer.Colorizer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonManagerCycle;
import net.minecraft.core.world.season.Seasons;

public class Colorizers {
    public static Minecraft mc;
    private static List<Colorizer> allColorizers;
    public static Colorizer grass;
    public static Colorizer water;
    public static Colorizer sky;
    public static Colorizer fog;
    public static Colorizer oak;
    public static Colorizer birch;
    public static Colorizer pine;
    public static Colorizer cherry;
    public static Colorizer shrub;
    public static Colorizer eucalyptus;
    public static Colorizer cacao;
    public static Colorizer thorn;
    public static Colorizer palm;
    private static Season lastSeason;
    private static float lastSeasonProgress;
    private static float fadeDuration;

    public static void init(Minecraft minecraft) {
        mc = minecraft;
        Colorizers.registerColorizers();
    }

    public static void reload() {
        List<Season> seasons = Seasons.getAllSeasons();
        for (int i = 0; i < allColorizers.size(); ++i) {
            allColorizers.get(i).setup(mc, seasons);
        }
        Colorizers.update(true);
    }

    public static void registerColorizers() {
        allColorizers = new ArrayList<Colorizer>();
        grass = Colorizers.add(new Colorizer("grass"));
        water = Colorizers.add(new Colorizer("water"));
        sky = Colorizers.add(new Colorizer("sky"));
        fog = Colorizers.add(new Colorizer("fog"));
        oak = Colorizers.add(new Colorizer("oak"));
        birch = Colorizers.add(new Colorizer("birch"));
        pine = Colorizers.add(new Colorizer("pine"));
        cherry = Colorizers.add(new Colorizer("cherry"));
        shrub = Colorizers.add(new Colorizer("shrub"));
        eucalyptus = Colorizers.add(new Colorizer("eucalyptus"));
        cacao = Colorizers.add(new Colorizer("cacao"));
        thorn = Colorizers.add(new Colorizer("thorn"));
        palm = Colorizers.add(new Colorizer("palm"));
    }

    public static void update(boolean force) {
        float blendFactor;
        Season season2;
        Season season1;
        World world = Colorizers.mc.theWorld;
        if (world == null) {
            return;
        }
        Season currentSeason = world.seasonManager.getCurrentSeason();
        float seasonProgress = Colorizers.getSeasonProgress(world);
        boolean update = force ? true : (currentSeason != lastSeason ? true : seasonProgress != lastSeasonProgress);
        if (!update) {
            return;
        }
        lastSeason = currentSeason;
        lastSeasonProgress = seasonProgress;
        System.out.println("Updating Colorizers");
        float fadeDurationInverse = 1.0f - fadeDuration;
        if (seasonProgress < 0.5f) {
            season1 = world.getSeasonManager().getPreviousSeason();
            season2 = currentSeason;
            blendFactor = seasonProgress + 0.5f;
            if (fadeDuration == 0.0f) {
                blendFactor = 1.0f;
            } else {
                blendFactor = seasonProgress * 2.0f;
                blendFactor /= fadeDuration;
                blendFactor = MathHelper.clamp(blendFactor, 0.0f, 1.0f);
                blendFactor = blendFactor * 0.5f + 0.5f;
            }
        } else {
            season1 = currentSeason;
            season2 = world.getSeasonManager().getNextSeason();
            blendFactor = seasonProgress - 0.5f;
            if (fadeDuration == 0.0f) {
                blendFactor = 0.0f;
            } else if (fadeDuration != 1.0f) {
                blendFactor = (seasonProgress - 0.5f) * 2.0f;
                blendFactor /= fadeDurationInverse;
                blendFactor -= 1.0f / fadeDurationInverse * fadeDuration;
                blendFactor = MathHelper.clamp(blendFactor, 0.0f, 1.0f);
            }
        }
        for (int i = 0; i < allColorizers.size(); ++i) {
            allColorizers.get(i).update(season1, season2, blendFactor);
        }
    }

    public static Colorizer add(Colorizer colorizer) {
        allColorizers.add(colorizer);
        return colorizer;
    }

    public static boolean loadColorData(ColorMap colorMap, String name) {
        String path = "/assets/minecraft/textures/colormap/" + colorMap.colorizer.name + "/" + name + ".png";
        InputStream in = null;
        BufferedImage image = null;
        try {
            in = Colorizers.mc.texturePackList.getResourceAsStream(path);
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Loading colormap: '" + name + "'", e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        if (image.getWidth() == 1 && image.getHeight() == 1) {
            int rgb = image.getRGB(0, 0);
            for (int i = 0; i < colorMap.buffer.length; ++i) {
                colorMap.buffer[i] = rgb;
            }
            return true;
        }
        if (image.getWidth() != 256 || image.getHeight() != 256) {
            BufferedImage fixedImage = new BufferedImage(256, 256, 1);
            Graphics g = fixedImage.getGraphics();
            g.drawImage(image, 0, 0, 256, 256, null);
            g.dispose();
            image = fixedImage;
        }
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                int rgb;
                colorMap.buffer[y << 8 | x] = rgb = image.getRGB(x, y);
            }
        }
        return true;
    }

    public static float getSeasonProgress(World world) {
        if (world.seasonManager instanceof SeasonManagerCycle) {
            SeasonManagerCycle seasonManager = (SeasonManagerCycle)world.seasonManager;
            Season currentSeason = seasonManager.getCurrentSeason();
            int dayInSeason = seasonManager.getDayInSeason();
            int dayLengthTicks = 24000;
            int seasonLengthDays = seasonManager.getSeasonLengthTicks(currentSeason) / dayLengthTicks;
            return (float)dayInSeason / (float)seasonLengthDays;
        }
        return 0.5f;
    }

    static {
        allColorizers = null;
        fadeDuration = 1.0f;
    }
}

