/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTextureRotating;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.util.helper.Textures;

public abstract class DynamicTextureAbstractClock
extends DynamicTextureRotating {
    public DynamicTextureAbstractClock(Minecraft minecraft, String dialTexture, IconCoordinate textureIndex) {
        super(minecraft, textureIndex);
        BufferedImage dialImage = Textures.readImage(minecraft.texturePackList.getResourceAsStream(dialTexture));
        if (dialImage.getWidth() != dialImage.getHeight()) {
            throw new RuntimeException("Dial Texture " + dialTexture + " is not square!");
        }
        this.dialTexRes = dialImage.getWidth();
        this.dialImageData = new byte[dialImage.getWidth() * dialImage.getWidth() * 4];
        for (int x = 0; x < this.dialTexRes; ++x) {
            for (int y = 0; y < this.dialTexRes; ++y) {
                DynamicTextureAbstractClock.putPixel(this.dialImageData, y * this.dialTexRes + x, dialImage.getRGB(x, y));
            }
        }
    }
}

