/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTextureRotating;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;

public class DynamicTextureTrommel
extends DynamicTextureRotating {
    private boolean counterClockwise;
    private double rotation = 0.0;
    private double speed = 0.12;

    public DynamicTextureTrommel(Minecraft minecraft, IconCoordinate textureIndex, boolean counterClockwise) {
        super(minecraft, textureIndex);
        int y;
        int x;
        this.counterClockwise = counterClockwise;
        BufferedImage bufferedimage = textureIndex.parentAtlas.atlas;
        IconCoordinate background = TextureRegistry.getTexture("minecraft:block/trommel_active_front_background");
        IconCoordinate foreground = TextureRegistry.getTexture("minecraft:block/trommel_active_front_foreground");
        this.dialImageData = new byte[textureIndex.getArea() * 4];
        for (x = 0; x < textureIndex.width; ++x) {
            for (y = 0; y < textureIndex.height; ++y) {
                DynamicTextureTrommel.putPixel(this.dialImageData, y * textureIndex.width + x, bufferedimage.getRGB(foreground.iconX + x, foreground.iconY + y));
            }
        }
        this.clockImageData = new byte[textureIndex.getArea() * 4];
        for (x = 0; x < textureIndex.width; ++x) {
            for (y = 0; y < textureIndex.height; ++y) {
                DynamicTextureTrommel.putPixel(this.clockImageData, y * textureIndex.width + x, bufferedimage.getRGB(background.iconX + x, background.iconY + y));
            }
        }
        this.dialTexRes = textureIndex.height;
    }

    @Override
    public double getAngle() {
        return 0.0;
    }

    @Override
    public void updateAngle() {
        if (this.counterClockwise) {
            this.rotation -= this.speed;
            if (this.rotation < 0.0) {
                this.rotation += Math.PI * 2;
            }
        } else {
            this.rotation += this.speed;
            if (this.rotation > Math.PI * 2) {
                this.rotation -= Math.PI * 2;
            }
        }
        this.angleFinal = this.rotation;
    }
}

