/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.model.ModelPlayerSlim;
import net.minecraft.core.entity.monster.EntityHuman;
import org.lwjgl.opengl.GL11;

public class MonsterRenderer
extends LivingRenderer<EntityHuman> {
    private final ModelBiped modelBipedMain;
    private final ModelPlayer modelThick;
    private final ModelPlayer modelSlim;

    public MonsterRenderer() {
        super(new ModelPlayer(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelThick = new ModelPlayer(0.0f);
        this.modelSlim = new ModelPlayerSlim(0.0f);
    }

    @Override
    public void render(EntityHuman entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.mainModel = entity.slimModel ? this.modelSlim : this.modelThick;
        double yRender = y - (double)entity.heightOffset;
        if (entity.isSneaking()) {
            yRender -= 0.125;
        }
        super.render(entity, x, yRender, z, yaw, partialTick);
        GL11.glDisable((int)3042);
    }

    @Override
    protected void preRenderCallback(EntityHuman entity, float f) {
        float scale = 0.9375f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    @Override
    public void loadEntityTexture(EntityHuman entity) {
        this.loadDownloadableTexture(entity.skinUrl, entity.getEntityTexture(), PlayerSkinParser.instance);
    }
}

