/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelQuadruped;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.util.helper.MathHelper;

public class ModelSheep
extends ModelQuadruped {
    boolean isEatingAnimPlaying;
    float headBobTime;

    public ModelSheep() {
        super(12, 0.0f);
        this.head = new Cube(0, 0);
        this.head.addBox(-3.0f, -4.0f, -6.0f, 6, 6, 8, 0.0f);
        this.head.setRotationPoint(0.0f, 6.0f, -8.0f);
        this.body = new Cube(28, 8);
        this.body.addBox(-4.0f, -10.0f, -7.0f, 8, 16, 6, 0.0f);
        this.body.setRotationPoint(0.0f, 5.0f, 2.0f);
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setRotationAngles(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        float desiredRotateAngleX = headPitch / 57.29578f;
        float desiredRotateAngleY = headYaw / 57.29578f;
        if (this.isEatingAnimPlaying) {
            if (this.headBobTime < 5.0f) {
                float partPercentage = this.headBobTime / 5.0f;
                this.head.rotateAngleX = desiredRotateAngleX * (1.0f - partPercentage) + 1.0472f * partPercentage;
                this.head.rotateAngleY = desiredRotateAngleY * (1.0f - partPercentage);
            } else if (this.headBobTime < 35.0f) {
                this.head.rotateAngleX = 1.0472f;
                this.head.rotateAngleY = 0.0f;
            } else if (this.headBobTime < 40.0f) {
                float partPercentage = (this.headBobTime - 35.0f) / 5.0f;
                this.head.rotateAngleX = desiredRotateAngleX * partPercentage + 1.0472f * (1.0f - partPercentage);
                this.head.rotateAngleY = desiredRotateAngleY * partPercentage;
            }
        } else {
            this.head.rotateAngleX = desiredRotateAngleX;
            this.head.rotateAngleY = desiredRotateAngleY;
        }
    }

    @Override
    public void setLivingAnimations(EntityLiving entityliving, float limbSwing, float limbYaw, float partialTick) {
        EntitySheep entitySheep = (EntitySheep)entityliving;
        this.head.rotationPointY = 6.0f;
        this.isEatingAnimPlaying = false;
        if (entitySheep.getIsSheepEating()) {
            this.headBobTime = (float)entitySheep.prevTimeSheepEating + (float)(entitySheep.timeSheepEating - entitySheep.prevTimeSheepEating) * partialTick;
            this.isEatingAnimPlaying = true;
            if (this.headBobTime < 5.0f) {
                this.head.rotationPointY = 6.0f + 2.0f * (this.headBobTime + 1.0f);
            } else if (this.headBobTime < 35.0f) {
                this.head.rotationPointY = 16.0f + MathHelper.sin(this.headBobTime * 0.05f * 30.5f) / 3.0f;
            } else if (this.headBobTime < 40.0f) {
                this.head.rotationPointY = 16.0f - 2.0f * (this.headBobTime - 34.0f);
            }
        } else {
            this.headBobTime = 0.0f;
        }
    }
}

