/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.CodecMus;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundPool;
import net.minecraft.client.sound.SoundPoolEntry;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundManager {
    private static SoundSystem sndSystem;
    private static boolean loaded;
    private static final int MUSINTERVAL = 6000;
    private final SoundPool soundPoolSounds = new SoundPool();
    private final SoundPool soundPoolStreaming = new SoundPool();
    private final SoundPool soundPoolMusic = new SoundPool();
    private final SoundPool cave = new SoundPool();
    private int soundId = 0;
    private GameSettings options;
    private final Random rand = new Random();
    private Minecraft mc;
    private int ticksBeforeMusic = this.rand.nextInt(6000);
    private boolean muted = false;

    private static void loadModAudio(String s, SoundPool soundpool) {
        File file = Minecraft.getAppDir(s);
        try {
            SoundManager.walkFolder(file, file, soundpool);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static void walkFolder(File file, File file1, SoundPool soundpool) throws IOException {
        File[] afile;
        if ((file1.exists() || file1.mkdirs()) && (afile = file1.listFiles()) != null && afile.length > 0) {
            for (int i = 0; i < afile.length; ++i) {
                if (afile[i].getName().startsWith(".")) continue;
                if (afile[i].isDirectory()) {
                    SoundManager.walkFolder(file, afile[i], soundpool);
                    continue;
                }
                if (!afile[i].isFile()) continue;
                String s = afile[i].getPath().substring(file.getPath().length() + 1).replace('\\', '/');
                soundpool.addSound(s, afile[i]);
            }
        }
    }

    public void addMusic(String s, File file) {
        this.soundPoolMusic.addSound(s, file);
    }

    public void addSound(String s, File file) {
        this.soundPoolSounds.addSound(s, file);
    }

    public void addStreaming(String s, File file) {
        this.soundPoolStreaming.addSound(s, file);
    }

    public void closeMinecraft() {
        if (loaded) {
            sndSystem.cleanup();
        }
    }

    public void setMuted(boolean muted) {
        if (sndSystem == null) {
            return;
        }
        this.muted = muted;
        if (this.muted) {
            sndSystem.setVolume("BgMusic", 0.0f);
        } else {
            sndSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
        }
    }

    public void updateListenerPosition(EntityLiving listeningEntity, float partialTick) {
        if (!loaded || this.muted || sndSystem == null || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        if (listeningEntity != null) {
            float f1 = listeningEntity.yRotO + (listeningEntity.yRot - listeningEntity.yRotO) * partialTick;
            double playerX = listeningEntity.xo + (listeningEntity.x - listeningEntity.xo) * (double)partialTick;
            double playerY = listeningEntity.yo + (listeningEntity.y - listeningEntity.yo) * (double)partialTick;
            double playerZ = listeningEntity.zo + (listeningEntity.z - listeningEntity.zo) * (double)partialTick;
            float f2 = MathHelper.cos(-f1 * 0.01745329f - 3.141593f);
            float f3 = MathHelper.sin(-f1 * 0.01745329f - 3.141593f);
            float f4 = -f3;
            float f5 = 0.0f;
            float f6 = -f2;
            float f7 = 0.0f;
            float f8 = 1.0f;
            float f9 = 0.0f;
            sndSystem.setListenerPosition((float)playerX, (float)playerY, (float)playerZ);
            sndSystem.setListenerOrientation(f4, 0.0f, f6, 0.0f, 1.0f, 0.0f);
        }
    }

    public void loadSoundSettings(GameSettings gamesettings) {
        this.soundPoolStreaming.field_1657_b = false;
        this.options = gamesettings;
        if (!loaded && gamesettings != null && SoundCategoryHelper.isAnyEnabled(gamesettings)) {
            this.tryToSetLibraryAndCodecs();
        }
        SoundManager.loadModAudio("minecraft-bta/resources/mod/sound", this.soundPoolSounds);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/streaming", this.soundPoolStreaming);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/music", this.soundPoolMusic);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/cavemusic", this.cave);
        try {
            Field field = Minecraft.class.getDeclaredFields()[1];
            field.setAccessible(true);
            this.mc = (Minecraft)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onSoundOptionsChanged() {
        if (!loaded && SoundCategoryHelper.isAnyEnabled(this.options)) {
            this.tryToSetLibraryAndCodecs();
        }
        if (sndSystem != null && loaded) {
            if (SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
                sndSystem.stop("BgMusic");
            } else {
                sndSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
            }
        }
    }

    public void playRandomMusicIfReady() {
        if (!loaded || sndSystem == null || SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
            return;
        }
        if (!sndSystem.playing("BgMusic") && !sndSystem.playing("streaming")) {
            if (this.ticksBeforeMusic > 0) {
                --this.ticksBeforeMusic;
                return;
            }
            SoundPoolEntry soundpoolentry = this.mc != null && this.mc.thePlayer != null && !this.mc.thePlayer.world.canBlockSeeTheSky(MathHelper.floor_double(this.mc.thePlayer.x), MathHelper.floor_double(this.mc.thePlayer.y), MathHelper.floor_double(this.mc.thePlayer.z)) ? this.cave.getRandomSound() : this.soundPoolMusic.getRandomSound();
            if (soundpoolentry != null) {
                this.ticksBeforeMusic = this.rand.nextInt(6000) + 6000;
                sndSystem.backgroundMusic("BgMusic", soundpoolentry.soundUrl, soundpoolentry.soundName, false);
                sndSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
                sndSystem.play("BgMusic");
            }
        }
    }

    public void playSound(String soundPath, SoundCategory category, float x, float y, float z, float volume, float pitch) {
        if (!loaded || sndSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(soundPath);
        if (soundpoolentry != null && volume > 0.0f) {
            this.soundId = (this.soundId + 1) % 256;
            String soundIdName = "sound_" + this.soundId;
            float f5 = 16.0f;
            if (volume > 1.0f) {
                f5 *= volume;
            }
            sndSystem.newSource(volume > 1.0f, soundIdName, soundpoolentry.soundUrl, soundpoolentry.soundName, false, x, y, z, 2, f5);
            sndSystem.setPitch(soundIdName, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            sndSystem.setVolume(soundIdName, volume * SoundCategoryHelper.getEffectiveVolume(category, this.options));
            sndSystem.play(soundIdName);
        }
    }

    public void playSound(String soundPath, SoundCategory category, float volume, float pitch) {
        if (!loaded || sndSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(soundPath);
        if (soundpoolentry != null) {
            this.soundId = (this.soundId + 1) % 256;
            String soundName = "sound_" + this.soundId;
            sndSystem.newSource(false, soundName, soundpoolentry.soundUrl, soundpoolentry.soundName, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            sndSystem.setPitch(soundName, pitch);
            sndSystem.setVolume(soundName, (volume *= 0.25f) * SoundCategoryHelper.getEffectiveVolume(category, this.options));
            sndSystem.play(soundName);
        }
    }

    public void playSound(String soundPath, SoundCategory category, float volume, float pitch, String soundID) {
        if (!loaded || sndSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(soundPath);
        if (soundpoolentry != null) {
            sndSystem.newSource(false, soundID, soundpoolentry.soundUrl, soundpoolentry.soundName, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            sndSystem.setPitch(soundID, pitch);
            sndSystem.setVolume(soundID, (volume *= 0.25f) * SoundCategoryHelper.getEffectiveVolume(category, this.options));
            sndSystem.play(soundID);
        }
    }

    public void playStreaming(String soundPath, float x, float y, float z, float volume, float pitch) {
        if (!loaded || sndSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        String streaming = "streaming";
        if (sndSystem.playing("streaming")) {
            sndSystem.stop("streaming");
        }
        if (soundPath == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolStreaming.getRandomSoundFromSoundPool(soundPath);
        if (soundpoolentry != null && volume > 0.0f) {
            if (sndSystem.playing("BgMusic")) {
                sndSystem.stop("BgMusic");
            }
            float streamingVolume = 16.0f;
            sndSystem.newStreamingSource(true, "streaming", soundpoolentry.soundUrl, soundpoolentry.soundName, false, x, y, z, 2, 64.0f);
            sndSystem.setVolume("streaming", 0.5f * ((Float)this.options.masterVolume.value).floatValue());
            sndSystem.play("streaming");
        }
    }

    private void tryToSetLibraryAndCodecs() {
        try {
            int i;
            float[] volumeStore = new float[SoundCategory.values().length];
            for (i = 0; i < SoundCategory.values().length; ++i) {
                volumeStore[i] = SoundCategoryHelper.getVolume(SoundCategory.values()[i], this.options);
            }
            this.options.saveOptions();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec((String)"mus", CodecMus.class);
            SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
            sndSystem = new SoundSystem();
            for (i = 0; i < SoundCategory.values().length; ++i) {
                SoundCategoryHelper.setVolume(SoundCategory.values()[i], this.options, volumeStore[i]);
            }
            this.options.saveOptions();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    public static SoundSystem getSoundSystem() {
        return sndSystem;
    }

    static {
        loaded = false;
    }
}

