/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFirestriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;

public class BlockBrazier
extends Block {
    private final boolean burning;

    public BlockBrazier(String key, int id, boolean burning) {
        super(key, id, Material.metal);
        this.burning = burning;
    }

    public boolean isBurning() {
        return this.burning;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Block.brazierInactive, 1)};
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemFirestriker && !this.burning) {
            if (world.getBlock(x + 1, y, z) instanceof BlockFluid || world.getBlock(x - 1, y, z) instanceof BlockFluid || world.getBlock(x, y, z + 1) instanceof BlockFluid || world.getBlock(x, y, z - 1) instanceof BlockFluid) {
                return false;
            }
            world.setBlockAndMetadataWithNotify(x, y, z, Block.brazierActive.id, 0);
            heldItem.damageItem(1, player);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        if (heldItem == null && this.burning) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.brazierInactive.id, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (this.burning) {
            Block.fire.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.burning) {
            return;
        }
        Block block = Block.blocksList[blockId];
        if (block instanceof BlockFluid) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.brazierInactive.id, 0);
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (this.burning) {
            Block.fire.randomDisplayTick(world, x, y, z, rand);
        }
    }
}

