/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockDoor
extends Block {
    public final boolean isTop;

    public BlockDoor(String key, int id, Material material, boolean isTop) {
        super(key, id, material);
        this.isTop = isTop;
        float f = 0.5f;
        if (isTop) {
            this.setBlockBounds(0.5f - f, -1.0, 0.5f - f, 0.5f + f, 1.0, 0.5f + f);
        } else {
            this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 2.0, 0.5f + f);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setDoorRotation(this.getState(world.getBlockMetadata(x, y, z)), true);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.setDoorRotation(this.getState(world.getBlockMetadata(x, y, z)), false);
    }

    public void setDoorRotation(int i, boolean drawingSelection) {
        float top = 1.0f;
        float bottom = 0.0f;
        if (this.isTop && drawingSelection) {
            top = 1.0f;
            bottom = -1.0f;
        } else if (drawingSelection) {
            top = 2.0f;
            bottom = 0.0f;
        }
        float f = 0.1875f;
        this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, 1.0);
        if (i == 0) {
            this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, f);
        }
        if (i == 1) {
            this.setBlockBounds(1.0f - f, bottom, 0.0, 1.0, top, 1.0);
        }
        if (i == 2) {
            this.setBlockBounds(0.0, bottom, 1.0f - f, 1.0, top, 1.0);
        }
        if (i == 3) {
            this.setBlockBounds(0.0, bottom, 0.0, f, top, 1.0);
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (!player.isSneaking()) {
            this.blockActivated(world, x, y, z, player);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (this.blockMaterial == Material.metal) {
            return false;
        }
        int l = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof BlockDoor) {
                Block.blocksList[world.getBlockId(x, y - 1, z)].blockActivated(world, x, y - 1, z, player);
            }
            return true;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x, y + 1, z, l ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playSoundEffect(player, 1003, x, y, z, 0);
        return true;
    }

    public void onPoweredBlockChange(World world, int x, int y, int z, boolean isPowered) {
        boolean isOpen;
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) > 0) {
            boolean bl = isPowered = !isPowered;
        }
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof BlockDoor) {
                ((BlockDoor)Block.blocksList[world.getBlockId(x, y - 1, z)]).onPoweredBlockChange(world, x, y - 1, z, isPowered);
            }
            return;
        }
        boolean bl = isOpen = (world.getBlockMetadata(x, y, z) & 4) > 0;
        if (isOpen == isPowered) {
            return;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x, y + 1, z, l ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playSoundEffect(null, 1003, x, y, z, 0);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int i1 = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            Block otherBlock = Block.blocksList[world.getBlockId(x, y - 1, z)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(x, y, z, 0);
            }
            if (blockId > 0 && Block.blocksList[blockId].canProvidePower()) {
                otherBlock.onNeighborBlockChange(world, x, y - 1, z, blockId);
            }
        } else {
            boolean flag = false;
            Block otherBlock = Block.blocksList[world.getBlockId(x, y + 1, z)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(x, y, z, 0);
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
                world.setBlockWithNotify(x, y, z, 0);
                flag = true;
                if (otherBlock instanceof BlockDoor) {
                    world.setBlockWithNotify(x, y + 1, z, 0);
                }
            }
            if (flag) {
                if (!world.isClientSide) {
                    // empty if block
                }
            } else if (blockId > 0 && Block.blocksList[blockId].canProvidePower()) {
                boolean flag1 = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
                this.onPoweredBlockChange(world, x, y, z, flag1);
            }
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int myId = world.getBlockId(x, y, z);
        int myMetadata = world.getBlockMetadata(x, y, z);
        int upId = world.getBlockId(x, y + 1, z);
        if (myId == Block.doorPlanksOakBottom.id && upId == Block.doorPlanksOakBottom.id) {
            world.setBlockAndMetadata(x, y + 1, z, Block.doorPlanksOakTop.id, myMetadata);
        } else if (myId == Block.doorIronBottom.id && upId == Block.doorIronBottom.id) {
            world.setBlockAndMetadata(x, y + 1, z, Block.doorIronTop.id, myMetadata);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (this.blockMaterial == Material.metal && dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(Item.doorIron)};
        }
        if (this.blockMaterial == Material.wood) {
            return new ItemStack[]{new ItemStack(Item.doorOak)};
        }
        return null;
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3d start, Vec3d end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.collisionRayTrace(world, x, y, z, start, end);
    }

    public int getState(int i) {
        if ((i & 4) == 0) {
            return i - 1 & 3;
        }
        return i & 3;
    }

    public static boolean isOpen(int i) {
        boolean hasRightHinge = (i & 8) != 0;
        boolean opened = (i & 4) != 0;
        return !hasRightHinge && opened || hasRightHinge && !opened;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (y >= world.getHeightBlocks() - 1) {
            return false;
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && super.canPlaceBlockAt(world, x, y, z) && super.canPlaceBlockAt(world, x, y + 1, z);
    }

    @Override
    public int getPistonPushReaction() {
        return 1;
    }
}

