/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public abstract class BlockEdible
extends Block {
    public Item item;
    public int maxBites;
    public int healAmount;

    public BlockEdible(String key, int id, int maxBites, int healAmount) {
        super(key, id, Material.cake);
        this.maxBites = maxBites;
        this.healAmount = healAmount;
        this.setTicking(true);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK || meta == 0) {
            return new ItemStack[]{new ItemStack(this.item)};
        }
        return null;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    private void eatSlice(World world, int x, int y, int z, EntityPlayer entityplayer) {
        if (entityplayer.getHealth() < entityplayer.getMaxHealth()) {
            entityplayer.heal(this.healAmount);
            int data = world.getBlockMetadata(x, y, z) + 1;
            if (data >= this.maxBites) {
                world.setBlockWithNotify(x, y, z, 0);
            } else {
                world.setBlockMetadataWithNotify(x, y, z, data);
                world.markBlockDirty(x, y, z);
            }
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        this.eatSlice(world, x, y, z, player);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.eatSlice(world, x, y, z, player);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!super.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        return this.canBlockStay(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return world.getBlockMaterial(x, y - 1, z).isSolid();
    }

    public void setItem(Item item) {
        this.item = item;
    }
}

