/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.noise.ImprovedNoise;

public class BlockGrass
extends Block {
    private static ImprovedNoise grassColorPerlin = new ImprovedNoise(new Random(0L));

    public BlockGrass(String key, int id, Material material) {
        super(key, id, material);
        this.setTicking(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockLightValue(x, y + 1, z) < 4 && Block.lightBlock[world.getBlockId(x, y + 1, z)] > 2) {
            if (rand.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(x, y, z, Block.dirt.id);
        } else if (world.getBlockLightValue(x, y + 1, z) >= 9) {
            int l = x + rand.nextInt(3) - 1;
            int i1 = y + rand.nextInt(5) - 3;
            int j1 = z + rand.nextInt(3) - 1;
            int k1 = world.getBlockId(l, i1 + 1, j1);
            if (world.getBlockId(l, i1, j1) == Block.dirt.id && world.getBlockLightValue(l, i1 + 1, j1) >= 4 && Block.lightBlock[k1] <= 2) {
                world.setBlockWithNotify(l, i1, j1, this.id);
            }
            if (world.getGameRule(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getBlockId(x, y + 1, z) == 0 && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().growFlowers && rand.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r = rand.nextInt(400);
                if (r < 26) {
                    idToSpawn = Block.flowerRed.id;
                } else if (r < 41) {
                    idToSpawn = Block.flowerYellow.id;
                } else if (r < 60) {
                    Biome biome = world.getBlockBiome(x, y + 1, z);
                    if (biome == Biomes.OVERWORLD_BIRCH_FOREST || biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
                        idToSpawn = Block.flowerPink.id;
                    } else if (biome == Biomes.OVERWORLD_MEADOW || biome == Biomes.OVERWORLD_BOREAL_FOREST || biome == Biomes.OVERWORLD_SHRUBLAND) {
                        idToSpawn = Block.flowerPurple.id;
                    } else if (biome == Biomes.OVERWORLD_FOREST || biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_RAINFOREST || biome == Biomes.OVERWORLD_CAATINGA) {
                        idToSpawn = Block.flowerLightBlue.id;
                    }
                } else {
                    idToSpawn = rand.nextInt(8) == 0 ? Block.tallgrassFern.id : Block.tallgrass.id;
                }
                world.setBlockWithNotify(x, y + 1, z, idToSpawn);
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return new ItemStack[]{new ItemStack(Block.dirt)};
    }
}

