/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityRecordPlayer;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockJukeBox
extends BlockTileEntity {
    public BlockJukeBox(String key, int id) {
        super(key, id, Material.wood);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        this.ejectRecord(world, x, y, z);
        return true;
    }

    public void playRecord(World world, int i, int j, int k, int l) {
        if (!world.isClientSide) {
            TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
            tileentityrecordplayer.record = l;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i, j, k, 1);
        }
    }

    public void ejectRecord(World world, int i, int j, int k) {
        if (world.isClientSide) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
        int l = tileentityrecordplayer.record;
        if (l != 0) {
            world.playSoundEffect(1005, i, j, k, 0);
            world.playRecord(null, null, i, j, k);
            tileentityrecordplayer.record = 0;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i, j, k, 0);
            int i1 = l;
            float f = 0.7f;
            double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        this.ejectRecord(world, x, y, z);
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityRecordPlayer();
    }
}

