/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRotatableHorizontal;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolSword;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class BlockPumpkin
extends BlockRotatableHorizontal {
    private final boolean isCarvable;

    public BlockPumpkin(String key, int id, boolean isCarvable) {
        super(key, id, Material.vegetable);
        this.setTicking(true);
        this.isCarvable = isCarvable;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (!this.isCarvable) {
            return false;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemToolSword) {
            heldItem.damageItem(1, player);
            world.setBlockAndMetadataWithNotify(x, y, z, Block.pumpkinCarvedIdle.id, player.getHorizontalPlacementDirection(Direction.getHorizontalDirection(player).getSide()).getOpposite().getId());
            return true;
        }
        return false;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
    }
}

