/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import java.util.List;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockMotionSensor;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class TileEntitySensor
extends TileEntity {
    private int getSightRange(World world, int x, int y, int z, int metadata) {
        int dx = 0;
        int dz = 0;
        switch (metadata) {
            case 2: {
                dz = -1;
                break;
            }
            case 3: {
                dz = 1;
                break;
            }
            case 4: {
                dx = -1;
                break;
            }
            case 5: {
                dx = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        int range = 2;
        Block blockInFront = world.getBlock(x + dx, y, z + dz);
        if (blockInFront != null && blockInFront.hasTag(BlockTags.EXTENDS_MOTION_SENSOR_RANGE)) {
            range = 5;
        }
        for (int i = 0; i < range; ++i) {
            if (!world.isBlockOpaqueCube(x + dx + i * dx, y, z + dz + i * dz)) continue;
            return i;
        }
        return range;
    }

    private AABB getDetectionBox(int x, int y, int z, int metadata, int effectiveRange) {
        if (metadata == 2) {
            return AABB.getBoundingBoxFromPool(x, y, z - effectiveRange, x + 1, (float)y + 1.0f, z + 1);
        }
        if (metadata == 3) {
            return AABB.getBoundingBoxFromPool(x, y, z, x + 1, (float)y + 1.0f, z + 1 + effectiveRange);
        }
        if (metadata == 4) {
            return AABB.getBoundingBoxFromPool(x - effectiveRange, y, z, x + 1, (float)y + 1.0f, z + 1);
        }
        return AABB.getBoundingBoxFromPool(x, y, z, x + 1 + effectiveRange, (float)y + 1.0f, z + 1);
    }

    @Override
    public void tick() {
        if (this.worldObj != null && !this.worldObj.isClientSide) {
            AABB detectionBox;
            List<Entity> list;
            boolean shouldBeActive = false;
            int metadata = this.worldObj.getBlockMetadata(this.x, this.y, this.z);
            int effectiveRange = this.getSightRange(this.worldObj, this.x, this.y, this.z, metadata);
            if (effectiveRange > 0 && !(list = this.worldObj.getEntitiesWithinAABB(Entity.class, detectionBox = this.getDetectionBox(this.x, this.y, this.z, metadata, effectiveRange))).isEmpty()) {
                for (Entity e : list) {
                    if (!(e instanceof EntityPlayer)) continue;
                    ((EntityPlayer)e).triggerAchievement(AchievementList.GET_SENSED);
                }
                shouldBeActive = true;
            }
            if (shouldBeActive && this.worldObj.getBlockId(this.x, this.y, this.z) != Block.motionsensorActive.id) {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.breath", 0.5f, this.worldObj.rand.nextFloat());
                BlockMotionSensor.updateSensorBlockState(true, this.worldObj, this.x, this.y, this.z);
            }
            if (!shouldBeActive && this.worldObj.getBlockId(this.x, this.y, this.z) != Block.motionsensorIdle.id) {
                BlockMotionSensor.updateSensorBlockState(false, this.worldObj, this.x, this.y, this.z);
            }
        }
    }
}

