/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.ItemStack;

public class RecipeCraftingShapedJsonAdapter
implements RecipeJsonAdapter<RecipeEntryCraftingShaped> {
    @Override
    public RecipeEntryCraftingShaped deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        List<String> pattern = obj.get("pattern").getAsJsonArray().asList().stream().map(JsonElement::getAsString).collect(Collectors.toList());
        List<RecipeSymbol> symbols = obj.get("symbols").getAsJsonArray().asList().stream().map(E -> (RecipeSymbol)context.deserialize((JsonElement)E, (Type)((Object)RecipeSymbol.class))).collect(Collectors.toList());
        ItemStack result = (ItemStack)context.deserialize(obj.get("result").getAsJsonObject(), (Type)((Object)ItemStack.class));
        boolean consumeContainers = obj.get("consumeContainers").getAsBoolean();
        return RecipeRegistry.parseRecipe(pattern, symbols, result, consumeContainers);
    }

    @Override
    public JsonElement serialize(RecipeEntryCraftingShaped src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", src.toString());
        obj.addProperty("type", Registries.RECIPE_TYPES.getKey(src.getClass()));
        RecipeSymbol[] symbols = (RecipeSymbol[])src.getInput();
        StringBuilder sb = new StringBuilder();
        for (RecipeSymbol recipeSymbol : symbols) {
            if (recipeSymbol == null) {
                sb.append(" ");
                continue;
            }
            if (recipeSymbol.getSymbol() == '\u0000') {
                sb.append(" ");
                continue;
            }
            sb.append(recipeSymbol.getSymbol());
        }
        String s = sb.toString();
        String[] pattern = s.split("(?<=\\G.{" + src.recipeWidth + "})");
        JsonArray arr = new JsonArray();
        for (String string : pattern) {
            arr.add(string);
        }
        ArrayList<RecipeSymbol> arrayList = new ArrayList<RecipeSymbol>();
        for (RecipeSymbol symbol : symbols) {
            if (symbol == null) continue;
            boolean found = false;
            for (RecipeSymbol recipeSymbol : arrayList) {
                if (recipeSymbol.getSymbol() != symbol.getSymbol()) continue;
                found = true;
                break;
            }
            if (found) continue;
            arrayList.add(symbol);
        }
        obj.add("pattern", arr);
        obj.add("symbols", context.serialize(arrayList));
        obj.add("result", context.serialize(src.getOutput()));
        obj.addProperty("consumeContainers", src.consumeContainerItem);
        return obj;
    }
}

