/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.HitResult;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityBobber
extends Entity {
    private int xTile;
    private int yTile;
    private int zTile;
    private boolean inGround;
    public EntityPlayer player;
    private int ticksInAir = 0;
    private int ticksCatchable = 0;
    public Entity hookedEntity = null;
    private int field_6388_l;
    private double field_6387_m;
    private double field_6386_n;
    private double field_6385_o;
    private double field_6384_p;
    private double field_6383_q;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityBobber(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
    }

    public EntityBobber(World world, double d, double d1, double d2) {
        this(world);
        this.setPos(d, d1, d2);
        this.ignoreFrustumCheck = true;
    }

    public EntityBobber(World world, EntityPlayer entityplayer) {
        super(world);
        this.ignoreFrustumCheck = true;
        this.player = entityplayer;
        this.player.bobberEntity = this;
        this.setSize(0.25f, 0.25f);
        this.moveTo(entityplayer.x, entityplayer.y + 1.62 - (double)entityplayer.heightOffset, entityplayer.z, entityplayer.yRot, entityplayer.xRot);
        this.x -= (double)(MathHelper.cos(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.y -= 0.1;
        this.z -= (double)(MathHelper.sin(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -MathHelper.sin(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.zd = MathHelper.cos(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.yd = -MathHelper.sin(this.xRot / 180.0f * (float)Math.PI) * f;
        this.func_4042_a(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getAverageEdgeLength() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void func_4042_a(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.random.nextGaussian() * 0.0075 * (double)f1;
        d1 += this.random.nextGaussian() * 0.0075 * (double)f1;
        d2 += this.random.nextGaussian() * 0.0075 * (double)f1;
        this.xd = d *= (double)f;
        this.yd = d1 *= (double)f;
        this.zd = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double(d * d + d2 * d2);
        this.yRotO = this.yRot = (float)(Math.atan2(d, d2) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(d1, f3) * 180.0 / Math.PI);
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.field_6387_m = x;
        this.field_6386_n = y;
        this.field_6385_o = z;
        this.field_6384_p = yRot;
        this.field_6383_q = xRot;
        this.field_6388_l = i;
        this.xd = this.velocityX;
        this.yd = this.velocityY;
        this.zd = this.velocityZ;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.velocityX = this.xd = xd;
        this.velocityY = this.yd = yd;
        this.velocityZ = this.zd = zd;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_6388_l > 0) {
            double d4;
            double d = this.x + (this.field_6387_m - this.x) / (double)this.field_6388_l;
            double d1 = this.y + (this.field_6386_n - this.y) / (double)this.field_6388_l;
            double d2 = this.z + (this.field_6385_o - this.z) / (double)this.field_6388_l;
            for (d4 = this.field_6384_p - (double)this.yRot; d4 < -180.0; d4 += 360.0) {
            }
            while (d4 >= 180.0) {
                d4 -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + d4 / (double)this.field_6388_l);
            this.xRot = (float)((double)this.xRot + (this.field_6383_q - (double)this.xRot) / (double)this.field_6388_l);
            --this.field_6388_l;
            this.setPos(d, d1, d2);
            this.setRot(this.yRot, this.xRot);
            return;
        }
        if (!this.world.isClientSide) {
            ItemStack heldPlayerItem = this.player.getCurrentEquippedItem();
            if (this.player.removed || !this.player.isAlive() || heldPlayerItem == null || heldPlayerItem.getItem() != Item.toolFishingrod || this.distanceToSqr(this.player) > 1024.0) {
                this.remove();
                this.player.bobberEntity = null;
                return;
            }
            if (this.hookedEntity != null) {
                if (this.hookedEntity.removed) {
                    this.hookedEntity = null;
                } else {
                    this.x = this.hookedEntity.x;
                    this.y = this.hookedEntity.bb.minY + (double)this.hookedEntity.bbHeight * 0.8;
                    this.z = this.hookedEntity.z;
                    return;
                }
            }
        }
        if (this.inGround) {
            if (this.world.getBlockId(this.xTile, this.yTile, this.zTile) == Block.rope.id) {
                this.x = (double)this.xTile + 0.5;
                this.y = (double)this.yTile + 0.5;
                this.z = (double)this.zTile + 0.5;
                return;
            }
            this.inGround = false;
            this.xd *= (double)(this.random.nextFloat() * 0.2f);
            this.yd *= (double)(this.random.nextFloat() * 0.2f);
            this.zd *= (double)(this.random.nextFloat() * 0.2f);
            this.ticksInAir = 0;
            this.ticksCatchable = 0;
        }
        ++this.ticksInAir;
        Vec3d currentPos = Vec3d.createVector(this.x, this.y, this.z);
        Vec3d nextPos = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult hitResult = this.world.checkBlockCollisionBetweenPoints(currentPos, nextPos);
        currentPos = Vec3d.createVector(this.x, this.y, this.z);
        nextPos = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (hitResult != null) {
            nextPos = Vec3d.createVector(hitResult.location.xCoord, hitResult.location.yCoord, hitResult.location.zCoord);
            if (hitResult.hitType == HitResult.HitType.TILE && this.world.getBlockId(hitResult.x, hitResult.y, hitResult.z) == Block.rope.id) {
                this.inGround = true;
                this.xTile = hitResult.x;
                this.yTile = hitResult.y;
                this.zTile = hitResult.z;
            }
        }
        Entity entity = null;
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.addCoord(this.xd, this.yd, this.zd).expand(1.0, 1.0, 1.0));
        double d3 = 0.0;
        for (Entity e : list) {
            double d6;
            float f2;
            AABB aabb;
            HitResult newHitResult;
            if (!e.isPickable() || e == this.player && this.ticksInAir < 5 || (newHitResult = (aabb = e.bb.expand(f2 = 0.3f, f2, f2)).func_1169_a(currentPos, nextPos)) == null || !((d6 = currentPos.distanceTo(newHitResult.location)) < d3) && d3 != 0.0) continue;
            entity = e;
            d3 = d6;
        }
        if (entity != null) {
            hitResult = new HitResult(entity);
        }
        if (hitResult != null && hitResult.entity != null && hitResult.entity.hurt(this.player, 0, DamageType.COMBAT)) {
            this.hookedEntity = hitResult.entity;
        }
        this.move(this.xd, this.yd, this.zd);
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / Math.PI);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float movementScale = 0.92f;
        if (this.onGround || this.horizontalCollision) {
            movementScale = 0.5f;
        }
        int k = 5;
        double d5 = 0.0;
        for (int l = 0; l < k; ++l) {
            double d8 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)l / (double)k - 0.125 + 0.125;
            double d9 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)(l + 1) / (double)k - 0.125 + 0.125;
            AABB axisalignedbb1 = AABB.getBoundingBoxFromPool(this.bb.minX, d8, this.bb.minZ, this.bb.maxX, d9, this.bb.maxZ);
            if (!this.world.isAABBInMaterial(axisalignedbb1, Material.water)) continue;
            d5 += 1.0 / (double)k;
        }
        if (d5 > 0.0) {
            if (this.ticksCatchable > 0) {
                --this.ticksCatchable;
            } else {
                int catchRate = 500;
                int rainRate = 0;
                int algaeRate = 0;
                if (this.world.canBlockBeRainedOn(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y) + 1, MathHelper.floor_double(this.z))) {
                    rainRate = 200;
                }
                if (this.world.getBlockId(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y) + 1, MathHelper.floor_double(this.z)) == Block.algae.id) {
                    algaeRate = 100;
                }
                if (this.random.nextInt(catchRate = catchRate - rainRate - algaeRate) == 0) {
                    double zOff;
                    this.ticksCatchable = this.random.nextInt(30) + 10;
                    this.yd -= 0.2;
                    this.world.playSoundAtEntity(null, this, "random.splash", 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    float f3 = MathHelper.floor_double(this.bb.minY);
                    int i1 = 0;
                    while ((float)i1 < 1.0f + this.bbWidth * 20.0f) {
                        double xOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        zOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        this.world.spawnParticle("bubble", this.x + xOff, f3 + 1.0f, this.z + zOff, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd, 0);
                        ++i1;
                    }
                    int j1 = 0;
                    while ((float)j1 < 1.0f + this.bbWidth * 20.0f) {
                        double xOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        zOff = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        this.world.spawnParticle("splash", this.x + xOff, f3 + 1.0f, this.z + zOff, this.xd, this.yd, this.zd, 0);
                        ++j1;
                    }
                }
            }
        }
        if (this.ticksCatchable > 0) {
            this.yd -= (double)(this.random.nextFloat() * this.random.nextFloat() * this.random.nextFloat()) * 0.2;
        }
        double d7 = d5 * 2.0 - 1.0;
        this.yd += 0.04 * d7;
        if (d5 > 0.0) {
            movementScale = (float)((double)movementScale * 0.9);
            this.yd *= 0.8;
        }
        this.xd *= (double)movementScale;
        this.yd *= (double)movementScale;
        this.zd *= (double)movementScale;
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public int yoink() {
        double distance;
        double dz;
        double dy;
        double dx;
        int damage = 0;
        if (this.inGround) {
            dx = this.x - this.player.x;
            dy = this.y - this.player.y;
            dz = this.z - this.player.z;
            distance = MathHelper.sqrt_double(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double clamp = 0.6;
            dx = MathHelper.clamp(dx, -clamp, clamp);
            dy = MathHelper.clamp(dy, -clamp, clamp);
            dz = MathHelper.clamp(dz, -clamp, clamp);
            double scale = 2.0;
            this.player.xd += dx * scale;
            this.player.yd += dy * scale;
            this.player.zd += dz * scale;
            damage = 5;
        }
        if (this.hookedEntity != null) {
            dx = this.player.x - this.x;
            dy = this.player.y - this.y;
            dz = this.player.z - this.z;
            distance = MathHelper.sqrt_double(dx * dx + dy * dy + dz * dz);
            double scale = 0.1;
            this.hookedEntity.xd += dx * scale;
            this.hookedEntity.yd += dy * scale + (double)MathHelper.sqrt_double(distance) * 0.08;
            this.hookedEntity.zd += dz * scale;
            damage = 3;
        } else if (this.ticksCatchable > 0) {
            EntityItem entityitem = new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.foodFishRaw));
            double dx2 = this.player.x - this.x;
            double dy2 = this.player.y - this.y;
            double dz2 = this.player.z - this.z;
            double distance2 = MathHelper.sqrt_double(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            double scale = 0.1;
            entityitem.xd = dx2 * scale;
            entityitem.yd = dy2 * scale + (double)MathHelper.sqrt_double(distance2) * 0.08;
            entityitem.zd = dz2 * scale;
            this.world.entityJoinedWorld(entityitem);
            this.player.addStat(StatList.fishCaughtStat, 1);
            damage = 1;
        }
        if (this.inGround) {
            damage = 2;
        }
        this.remove();
        this.player.bobberEntity = null;
        return damage;
    }
}

