/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.vehicle;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] cargoItems = new ItemStack[36];
    public int minecartCurrentDamage = 0;
    public int minecartTimeSinceHit = 0;
    public int minecartRockDirection = 1;
    private boolean field_856_i = false;
    public int minecartType;
    public int fuel;
    public double pushX;
    public double pushZ;
    private static final int[][][] field_855_j = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int field_9415_k;
    private double field_9414_l;
    private double field_9413_m;
    private double field_9412_n;
    private double field_9411_o;
    private double field_9410_p;
    private double field_9409_q;
    private double field_9408_r;
    private double field_9407_s;

    public EntityMinecart(World world) {
        super(world);
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.7f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    public EntityMinecart(World world, double d, double d1, double d2, int i) {
        this(world);
        this.setPos(d, d1 + (double)this.heightOffset, d2);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
        this.minecartType = i;
    }

    @Override
    public Entity ejectRider() {
        int z;
        int y;
        Entity entity = this.passenger;
        if (entity == null) {
            return null;
        }
        this.passenger = null;
        entity.vehicle = null;
        int x = MathHelper.floor_double(this.x);
        if (this.isSafe(x - 1, y = MathHelper.floor_double(this.y), z = MathHelper.floor_double(this.z))) {
            entity.moveTo((double)x - 0.5, y, (double)z + 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(x + 1, y, z)) {
            entity.moveTo((double)x + 1.5, y, (double)z + 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(x, y, z - 1)) {
            entity.moveTo((double)x + 0.5, y, (double)z - 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(x, y, z + 1)) {
            entity.moveTo((double)x + 0.5, y, (double)z + 1.5, entity.yRot, entity.xRot);
        } else {
            entity.moveTo((double)x + 0.5, y + 1, (double)z + 0.5, entity.yRot, entity.xRot);
        }
        return entity;
    }

    private boolean isSafe(int x, int y, int z) {
        return !this.world.isBlockNormalCube(x, y, z) && !this.world.isBlockNormalCube(x, y + 1, z);
    }

    @Override
    public double getRideHeight() {
        return (double)this.bbHeight * 0.0 - 0.3;
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        if (this.world.isClientSide || this.removed) {
            return true;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).getGamemode() == Gamemode.creative) {
            this.remove();
            return true;
        }
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.markHurt();
        this.minecartCurrentDamage += i * 10;
        if (this.minecartCurrentDamage > 40) {
            if (this.passenger != null) {
                this.passenger.startRiding(this);
            }
            this.remove();
            this.spawnAtLocation(Item.minecart.id, 1, 0.0f);
            if (this.minecartType == 1) {
                EntityMinecart entityminecart = this;
                for (int j = 0; j < entityminecart.getSizeInventory(); ++j) {
                    ItemStack itemstack = entityminecart.getStackInSlot(j);
                    if (itemstack == null) continue;
                    float f = this.random.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.stackSize > 0) {
                        int k = this.random.nextInt(21) + 10;
                        if (k > itemstack.stackSize) {
                            k = itemstack.stackSize;
                        }
                        itemstack.stackSize -= k;
                        EntityItem entityitem = new EntityItem(this.world, this.x + (double)f, this.y + (double)f1, this.z + (double)f2, new ItemStack(itemstack.itemID, k, itemstack.getMetadata()));
                        float f3 = 0.05f;
                        entityitem.xd = (float)this.random.nextGaussian() * f3 * 0.5f;
                        entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                        entityitem.zd = (float)this.random.nextGaussian() * f3 * 0.5f;
                        this.world.entityJoinedWorld(entityitem);
                    }
                }
                this.spawnAtLocation(Block.chestPlanksOak.id, 1, 0.0f);
            } else if (this.minecartType == 2) {
                this.spawnAtLocation(Block.furnaceStoneIdle.id, 1, 0.0f);
            }
        }
        return true;
    }

    @Override
    public void animateHurt() {
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.minecartCurrentDamage += this.minecartCurrentDamage * 10;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (itemstack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int j = this.random.nextInt(21) + 10;
                if (j > itemstack.stackSize) {
                    j = itemstack.stackSize;
                }
                itemstack.stackSize -= j;
                EntityItem entityitem = new EntityItem(this.world, this.x + (double)f, this.y + (double)f1, this.z + (double)f2, new ItemStack(itemstack.itemID, j, itemstack.getMetadata()));
                float f3 = 0.05f;
                entityitem.xd = (float)this.random.nextGaussian() * f3;
                entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.zd = (float)this.random.nextGaussian() * f3;
                this.world.entityJoinedWorld(entityitem);
            }
        }
        this.ejectRider();
        super.remove();
    }

    @Override
    public void tick() {
        if (this.minecartTimeSinceHit > 0) {
            --this.minecartTimeSinceHit;
        }
        if (this.minecartCurrentDamage > 0) {
            --this.minecartCurrentDamage;
        }
        double _x = this.x;
        double _y = this.y;
        double _z = this.z;
        this.onUpdate2();
        this.onUpdate2();
        this.xo = _x;
        this.yo = _y;
        this.zo = _z;
    }

    public void onUpdate2() {
        double d8;
        int k;
        int j;
        if (this.world.isClientSide && this.field_9415_k > 0) {
            if (this.field_9415_k > 0) {
                double d4;
                double d = this.x + (this.field_9414_l - this.x) / (double)this.field_9415_k;
                double d1 = this.y + (this.field_9413_m - this.y) / (double)this.field_9415_k;
                double d3 = this.z + (this.field_9412_n - this.z) / (double)this.field_9415_k;
                for (d4 = this.field_9411_o - (double)this.yRot; d4 < -180.0; d4 += 360.0) {
                }
                while (d4 >= 180.0) {
                    d4 -= 360.0;
                }
                this.yRot = (float)((double)this.yRot + d4 / (double)this.field_9415_k);
                this.xRot = (float)((double)this.xRot + (this.field_9410_p - (double)this.xRot) / (double)this.field_9415_k);
                --this.field_9415_k;
                this.setPos(d, d1, d3);
                this.setRot(this.yRot, this.xRot);
            } else {
                this.setPos(this.x, this.y, this.z);
                this.setRot(this.yRot, this.xRot);
            }
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= 0.04;
        int i = MathHelper.floor_double(this.x);
        if (BlockRail.isRailBlockAt(this.world, i, (j = MathHelper.floor_double(this.y)) - 1, k = MathHelper.floor_double(this.z))) {
            --j;
        }
        double d2 = 0.4;
        boolean flag = false;
        double d5 = 0.0078125;
        int l = this.world.getBlockId(i, j, k);
        if (BlockRail.isRailBlock(l)) {
            double d30;
            Vec3d vec3d = this.func_514_g(this.x, this.y, this.z);
            int i1 = this.world.getBlockMetadata(i, j, k);
            this.y = j;
            boolean flag1 = false;
            boolean flag2 = false;
            if (l == Block.railPowered.id) {
                flag1 = (i1 & 8) != 0;
                boolean bl = flag2 = !flag1;
            }
            if (((BlockRail)Block.blocksList[l]).getIsPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                this.y = j + 1;
            }
            if (i1 == 2) {
                this.xd -= d5;
            }
            if (i1 == 3) {
                this.xd += d5;
            }
            if (i1 == 4) {
                this.zd += d5;
            }
            if (i1 == 5) {
                this.zd -= d5;
            }
            int[][] ai = field_855_j[i1];
            double d9 = ai[1][0] - ai[0][0];
            double d10 = ai[1][2] - ai[0][2];
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            double d12 = this.xd * d9 + this.zd * d10;
            if (d12 < 0.0) {
                d9 = -d9;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
            this.xd = d13 * d9 / d11;
            this.zd = d13 * d10 / d11;
            if (flag2) {
                double d16 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                if (d16 < 0.03) {
                    this.xd *= 0.0;
                    this.yd *= 0.0;
                    this.zd *= 0.0;
                } else {
                    this.xd *= 0.5;
                    this.yd *= 0.0;
                    this.zd *= 0.5;
                }
            }
            double d17 = 0.0;
            double d18 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d19 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d20 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d21 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            d9 = d20 - d18;
            d10 = d21 - d19;
            if (d9 == 0.0) {
                this.x = (double)i + 0.5;
                d17 = this.z - (double)k;
            } else if (d10 == 0.0) {
                this.z = (double)k + 0.5;
                d17 = this.x - (double)i;
            } else {
                double d26;
                double d22 = this.x - d18;
                double d24 = this.z - d19;
                d17 = d26 = (d22 * d9 + d24 * d10) * 2.0;
            }
            this.x = d18 + d9 * d17;
            this.z = d19 + d10 * d17;
            this.setPos(this.x, this.y + (double)this.heightOffset, this.z);
            if (this.passenger != null && Math.hypot(this.xd, this.zd) < (double)0.01f) {
                this.xd += this.passenger.xd * 0.05;
                this.zd += this.passenger.zd * 0.05;
            }
            double d23 = this.xd;
            double d25 = this.zd;
            if (this.passenger != null) {
                d23 *= 0.75;
                d25 *= 0.75;
            }
            if (d23 < -d2) {
                d23 = -d2;
            }
            if (d23 > d2) {
                d23 = d2;
            }
            if (d25 < -d2) {
                d25 = -d2;
            }
            if (d25 > d2) {
                d25 = d2;
            }
            this.move(d23, 0.0, d25);
            if (ai[0][1] != 0 && MathHelper.floor_double(this.x) - i == ai[0][0] && MathHelper.floor_double(this.z) - k == ai[0][2]) {
                this.setPos(this.x, this.y + (double)ai[0][1], this.z);
            } else if (ai[1][1] != 0 && MathHelper.floor_double(this.x) - i == ai[1][0] && MathHelper.floor_double(this.z) - k == ai[1][2]) {
                this.setPos(this.x, this.y + (double)ai[1][1], this.z);
            }
            if (this.passenger != null) {
                this.xd *= 0.997;
                this.yd *= 0.0;
                this.zd *= 0.997;
            } else {
                if (this.minecartType == 2) {
                    double d27 = MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ);
                    if (d27 > 0.01) {
                        flag = true;
                        this.pushX /= d27;
                        this.pushZ /= d27;
                        double d29 = 0.04;
                        this.xd *= 0.8;
                        this.yd *= 0.0;
                        this.zd *= 0.8;
                        this.xd += this.pushX * d29;
                        this.zd += this.pushZ * d29;
                    } else {
                        this.xd *= 0.9;
                        this.yd *= 0.0;
                        this.zd *= 0.9;
                    }
                }
                this.xd *= 0.96;
                this.yd *= 0.0;
                this.zd *= 0.96;
            }
            Vec3d vec3d1 = this.func_514_g(this.x, this.y, this.z);
            if (vec3d1 != null && vec3d != null) {
                double d28 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
                double d14 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                if (d14 > 0.0) {
                    this.xd = this.xd / d14 * (d14 + d28);
                    this.zd = this.zd / d14 * (d14 + d28);
                }
                this.setPos(this.x, vec3d1.yCoord, this.z);
            }
            int k1 = MathHelper.floor_double(this.x);
            int l1 = MathHelper.floor_double(this.z);
            if (k1 != i || l1 != k) {
                double d15 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                this.xd = d15 * (double)(k1 - i);
                this.zd = d15 * (double)(l1 - k);
            }
            if (this.minecartType == 2 && (d30 = (double)MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ)) > 0.01 && this.xd * this.xd + this.zd * this.zd > 0.001) {
                this.pushX = this.xd;
                this.pushZ = this.zd;
            }
            if (flag1) {
                double d31 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                if (d31 > 0.01) {
                    double d32 = 0.06;
                    this.xd += this.xd / d31 * d32;
                    this.zd += this.zd / d31 * d32;
                } else if (i1 == 1) {
                    if (this.world.isBlockNormalCube(i - 1, j, k)) {
                        this.xd = 0.02;
                    } else if (this.world.isBlockNormalCube(i + 1, j, k)) {
                        this.xd = -0.02;
                    }
                } else if (i1 == 0) {
                    if (this.world.isBlockNormalCube(i, j, k - 1)) {
                        this.zd = 0.02;
                    } else if (this.world.isBlockNormalCube(i, j, k + 1)) {
                        this.zd = -0.02;
                    }
                }
            }
        } else {
            if (this.xd < -d2) {
                this.xd = -d2;
            }
            if (this.xd > d2) {
                this.xd = d2;
            }
            if (this.zd < -d2) {
                this.zd = -d2;
            }
            if (this.zd > d2) {
                this.zd = d2;
            }
            if (this.onGround) {
                this.xd *= 0.5;
                this.yd *= 0.5;
                this.zd *= 0.5;
            }
            this.move(this.xd, this.yd, this.zd);
            if (!this.onGround) {
                this.xd *= 0.95;
                this.yd *= 0.95;
                this.zd *= 0.95;
            }
        }
        this.xRot = 0.0f;
        double d6 = this.xo - this.x;
        double d7 = this.zo - this.z;
        if (d6 * d6 + d7 * d7 > 0.001) {
            this.yRot = (float)(Math.atan2(d7, d6) * 180.0 / Math.PI);
            if (this.field_856_i) {
                this.yRot += 180.0f;
            }
        }
        for (d8 = (double)(this.yRot - this.yRotO); d8 >= 180.0; d8 -= 360.0) {
        }
        while (d8 < -180.0) {
            d8 += 360.0;
        }
        if (d8 < -170.0 || d8 >= 170.0) {
            this.yRot += 180.0f;
            this.field_856_i = !this.field_856_i;
        }
        this.setRot(this.yRot, this.xRot);
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(0.2, 0.0, 0.2));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = list.get(j1);
                if (entity == this.passenger || !entity.isPushable() || !(entity instanceof EntityMinecart)) continue;
                entity.push(this);
            }
        }
        if (this.passenger != null && this.passenger.removed) {
            this.passenger = null;
        }
        if (flag && this.random.nextInt(4) == 0) {
            --this.fuel;
            if (this.fuel < 0) {
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.world.spawnParticle("largesmoke", this.x, this.y + 0.8, this.z, 0.0, 0.0, 0.0, 0);
        }
    }

    public Vec3d func_515_a(double d, double d1, double d2, double d3) {
        int l;
        int k;
        int j;
        int i = MathHelper.floor_double(d);
        if (BlockRail.isRailBlockAt(this.world, i, (j = MathHelper.floor_double(d1)) - 1, k = MathHelper.floor_double(d2))) {
            --j;
        }
        if (BlockRail.isRailBlock(l = this.world.getBlockId(i, j, k))) {
            int i1 = this.world.getBlockMetadata(i, j, k);
            if (((BlockRail)Block.blocksList[l]).getIsPowered()) {
                i1 &= 7;
            }
            d1 = j;
            if (i1 >= 2 && i1 <= 5) {
                d1 = j + 1;
            }
            int[][] ai = field_855_j[i1];
            double d4 = ai[1][0] - ai[0][0];
            double d5 = ai[1][2] - ai[0][2];
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (ai[0][1] != 0 && MathHelper.floor_double(d += (d4 /= d6) * d3) - i == ai[0][0] && MathHelper.floor_double(d2 += (d5 /= d6) * d3) - k == ai[0][2]) {
                d1 += (double)ai[0][1];
            } else if (ai[1][1] != 0 && MathHelper.floor_double(d) - i == ai[1][0] && MathHelper.floor_double(d2) - k == ai[1][2]) {
                d1 += (double)ai[1][1];
            }
            return this.func_514_g(d, d1, d2);
        }
        return null;
    }

    public Vec3d func_514_g(double d, double d1, double d2) {
        int l;
        int k;
        int j;
        int i = MathHelper.floor_double(d);
        if (BlockRail.isRailBlockAt(this.world, i, (j = MathHelper.floor_double(d1)) - 1, k = MathHelper.floor_double(d2))) {
            --j;
        }
        if (BlockRail.isRailBlock(l = this.world.getBlockId(i, j, k))) {
            int i1 = this.world.getBlockMetadata(i, j, k);
            d1 = j;
            if (((BlockRail)Block.blocksList[l]).getIsPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                d1 = j + 1;
            }
            int[][] ai = field_855_j[i1];
            double d3 = 0.0;
            double d4 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d5 = (double)j + 0.5 + (double)ai[0][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d7 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d8 = (double)j + 0.5 + (double)ai[1][1] * 0.5;
            double d9 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                d = (double)i + 0.5;
                d3 = d2 - (double)k;
            } else if (d12 == 0.0) {
                d2 = (double)k + 0.5;
                d3 = d - (double)i;
            } else {
                double d15;
                double d13 = d - d4;
                double d14 = d2 - d6;
                d3 = d15 = (d13 * d10 + d14 * d12) * 2.0;
            }
            d = d4 + d10 * d3;
            d1 = d5 + d11 * d3;
            d2 = d6 + d12 * d3;
            if (d11 < 0.0) {
                d1 += 1.0;
            }
            if (d11 > 0.0) {
                d1 += 0.5;
            }
            return Vec3d.createVector(d, d1, d2);
        }
        return null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Type", this.minecartType);
        if (this.minecartType == 2) {
            tag.putDouble("PushX", this.pushX);
            tag.putDouble("PushZ", this.pushZ);
            tag.putShort("Fuel", (short)this.fuel);
        } else if (this.minecartType == 1) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.cargoItems.length; ++i) {
                if (this.cargoItems[i] == null) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.putByte("Slot", (byte)i);
                this.cargoItems[i].writeToNBT(nbttagcompound1);
                nbttaglist.addTag(nbttagcompound1);
            }
            tag.put("Items", nbttaglist);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.minecartType = tag.getInteger("Type");
        if (this.minecartType == 2) {
            this.pushX = tag.getDouble("PushX");
            this.pushZ = tag.getDouble("PushZ");
            this.fuel = tag.getShort("Fuel");
        } else if (this.minecartType == 1) {
            ListTag nbttaglist = tag.getList("Items");
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
                int j = nbttagcompound1.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.cargoItems.length) continue;
                this.cargoItems[j] = ItemStack.readItemStackFromNbt(nbttagcompound1);
            }
        }
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void push(Entity entity) {
        double d1;
        double d;
        double d2;
        if (this.world.isClientSide) {
            return;
        }
        if (entity == this.passenger) {
            return;
        }
        if (!entity.isPushable()) {
            return;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer) && this.minecartType == 0 && this.xd * this.xd + this.zd * this.zd > 0.01 && this.passenger == null && entity.vehicle == null) {
            entity.startRiding(this);
        }
        if ((d2 = (d = entity.x - this.x) * d + (d1 = entity.z - this.z) * d1) >= (double)1.0E-4f) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= 0.1;
            d1 *= 0.1;
            d *= (double)(1.0f - this.pushthrough);
            d1 *= (double)(1.0f - this.pushthrough);
            d *= 0.5;
            d1 *= 0.5;
            if (entity instanceof EntityMinecart) {
                double d4 = entity.x - this.x;
                double d5 = entity.z - this.z;
                double d6 = d4 * entity.zd + d5 * entity.xo;
                if ((d6 *= d6) > 5.0) {
                    return;
                }
                double d7 = entity.xd + this.xd;
                double d8 = entity.zd + this.zd;
                if (((EntityMinecart)entity).minecartType == 2 && this.minecartType != 2) {
                    this.xd *= 0.2;
                    this.zd *= 0.2;
                    this.push(entity.xd - d, 0.0, entity.zd - d1);
                    entity.xd *= 0.7;
                    entity.zd *= 0.7;
                } else if (((EntityMinecart)entity).minecartType != 2 && this.minecartType == 2) {
                    entity.xd *= 0.2;
                    entity.zd *= 0.2;
                    entity.push(this.xd + d, 0.0, this.zd + d1);
                    this.xd *= 0.7;
                    this.zd *= 0.7;
                } else {
                    this.xd *= 0.2;
                    this.zd *= 0.2;
                    this.push((d7 /= 2.0) - d, 0.0, (d8 /= 2.0) - d1);
                    entity.xd *= 0.2;
                    entity.zd *= 0.2;
                    entity.push(d7 + d, 0.0, d8 + d1);
                }
            } else {
                this.push(-d, 0.0, -d1);
                entity.push(d / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.cargoItems[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.cargoItems[i] != null) {
            if (this.cargoItems[i].stackSize <= j) {
                ItemStack itemstack = this.cargoItems[i];
                this.cargoItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i].splitStack(j);
            if (this.cargoItems[i].stackSize <= 0) {
                this.cargoItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.cargoItems[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Minecart";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (this.minecartType == 0) {
            if (this.passenger != null && this.passenger instanceof EntityPlayer && this.passenger != entityplayer) {
                return true;
            }
            if (!this.world.isClientSide) {
                entityplayer.startRiding(this);
            }
        } else if (this.minecartType == 1) {
            if (!this.world.isClientSide) {
                entityplayer.displayGUIChest(this);
            }
        } else if (this.minecartType == 2) {
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null && LookupFuelFurnace.instance.getFuelYield(itemstack.itemID) > 0) {
                if (--itemstack.stackSize <= 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                this.fuel += (int)((float)LookupFuelFurnace.instance.getFuelYield(itemstack.itemID) / 1600.0f * 1200.0f);
            }
            this.pushX = this.x - entityplayer.x;
            this.pushZ = this.z - entityplayer.z;
        }
        return true;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.field_9414_l = x;
        this.field_9413_m = y;
        this.field_9412_n = z;
        this.field_9411_o = yRot;
        this.field_9410_p = xRot;
        this.field_9415_k = i + 2;
        this.xd = this.field_9409_q;
        this.yd = this.field_9408_r;
        this.zd = this.field_9407_s;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.field_9409_q = this.xd = xd;
        this.field_9408_r = this.yd = yd;
        this.field_9407_s = this.zd = zd;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.removed) {
            return false;
        }
        return entityplayer.distanceToSqr(this) <= 64.0;
    }

    @Override
    public void sortInventory() {
        InventorySorter.sortInventory(this.cargoItems);
    }
}

