/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.item.Item;
import net.minecraft.core.item.material.ArmorMaterial;

public class ItemArmor
extends Item {
    public static final int[] armorPieceProtectionValues = new int[]{3, 8, 6, 3};
    private static final float[] armorPieceDurabilityModifiers = new float[]{0.91f, 1.0f, 0.97f, 0.94f};
    public final ArmorMaterial material;
    public final int armorPiece;

    public ItemArmor(String name, int id, ArmorMaterial material, int armorPiece) {
        super(name, id);
        this.material = material;
        this.armorPiece = armorPiece;
        this.setMaxDamage((int)(armorPieceDurabilityModifiers[armorPiece] * (float)material.durability));
        this.maxStackSize = 1;
    }

    public int armorPieceProtection() {
        return armorPieceProtectionValues[this.armorPiece];
    }

    public float getArmorPieceProtectionPercentage() {
        return (float)this.armorPieceProtection() / 20.0f;
    }
}

