/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemRope
extends ItemPlaceable {
    public ItemRope(String name, int id, Block blockToPlace) {
        super(name, id, blockToPlace);
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (stack.stackSize <= 0) {
            return false;
        }
        boolean placeOnSide = true;
        if (world.getBlock(blockX, blockY, blockZ) == this.blockToPlace && !player.isSneaking()) {
            placeOnSide = false;
            int _y = blockY;
            while (_y > 0) {
                if (world.canBlockBePlacedAt(this.blockToPlace.id, blockX, --_y, blockZ, false, side)) {
                    blockY = _y;
                    break;
                }
                if (world.getBlock(blockX, _y, blockZ) == this.blockToPlace) continue;
            }
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockToPlace.id, blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.blockToPlace.id, placeOnSide ? 128 : 0)) {
                this.blockToPlace.onBlockPlaced(world, blockX, blockY, blockZ, side, player, yPlaced);
                world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.blockToPlace, EnumBlockSoundEffectType.PLACE);
            }
            return true;
        }
        return false;
    }
}

