/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.server.util.helper.PlayerList;

public class Packet72UpdatePlayerProfile
extends Packet {
    public String username;
    public String nickname;
    public int score;
    public byte chatColor;
    public boolean isOnline;
    public boolean isOperator;

    public Packet72UpdatePlayerProfile() {
    }

    public Packet72UpdatePlayerProfile(String username, String nickname, int score, byte chatColor, boolean isOnline, boolean isOperator) {
        this.username = username;
        this.nickname = nickname;
        this.score = score;
        this.chatColor = chatColor;
        this.isOnline = isOnline;
        this.isOperator = isOperator;
        PlayerList.updateList();
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.username = Packet72UpdatePlayerProfile.readString(dis, 16);
        this.nickname = Packet72UpdatePlayerProfile.readString(dis, 32);
        this.score = dis.readInt();
        this.chatColor = dis.readByte();
        this.isOnline = dis.readBoolean();
        this.isOperator = dis.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        Packet72UpdatePlayerProfile.writeString(this.username, dos);
        Packet72UpdatePlayerProfile.writeString(this.nickname, dos);
        dos.writeInt(this.score);
        dos.writeByte(this.chatColor);
        dos.writeBoolean(this.isOnline);
        dos.writeBoolean(this.isOperator);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleUpdatePlayerProfile(this);
    }

    @Override
    public int getPacketSize() {
        return 10 + this.username.length() + 4;
    }
}

