/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.phys;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HitResult;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3d;

public class AABB {
    private static List boundingBoxes = new ArrayList();
    private static int numBoundingBoxesInUse = 0;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;

    public static AABB getBoundingBox(double d, double d1, double d2, double d3, double d4, double d5) {
        return new AABB(d, d1, d2, d3, d4, d5);
    }

    public static void deinitializePool() {
        boundingBoxes.clear();
        numBoundingBoxesInUse = 0;
    }

    public static void initializePool() {
        numBoundingBoxesInUse = 0;
    }

    public static AABB getBoundingBoxFromPool(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (numBoundingBoxesInUse >= boundingBoxes.size()) {
            boundingBoxes.add(AABB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return ((AABB)boundingBoxes.get(numBoundingBoxesInUse++)).setBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AABB(double d, double d1, double d2, double d3, double d4, double d5) {
        this.minX = d;
        this.minY = d1;
        this.minZ = d2;
        this.maxX = d3;
        this.maxY = d4;
        this.maxZ = d5;
    }

    public AABB setBounds(double d, double d1, double d2, double d3, double d4, double d5) {
        this.minX = d;
        this.minY = d1;
        this.minZ = d2;
        this.maxX = d3;
        this.maxY = d4;
        this.maxZ = d5;
        return this;
    }

    public AABB addCoord(double d, double d1, double d2) {
        double d3 = this.minX;
        double d4 = this.minY;
        double d5 = this.minZ;
        double d6 = this.maxX;
        double d7 = this.maxY;
        double d8 = this.maxZ;
        if (d < 0.0) {
            d3 += d;
        }
        if (d > 0.0) {
            d6 += d;
        }
        if (d1 < 0.0) {
            d4 += d1;
        }
        if (d1 > 0.0) {
            d7 += d1;
        }
        if (d2 < 0.0) {
            d5 += d2;
        }
        if (d2 > 0.0) {
            d8 += d2;
        }
        return AABB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AABB expand(double d, double d1, double d2) {
        double d3 = this.minX - d;
        double d4 = this.minY - d1;
        double d5 = this.minZ - d2;
        double d6 = this.maxX + d;
        double d7 = this.maxY + d1;
        double d8 = this.maxZ + d2;
        return AABB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AABB getOffsetBoundingBox(double d, double d1, double d2) {
        return AABB.getBoundingBoxFromPool(this.minX + d, this.minY + d1, this.minZ + d2, this.maxX + d, this.maxY + d1, this.maxZ + d2);
    }

    public double calculateXOffset(AABB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return d;
        }
        if (axisalignedbb.maxZ <= this.minZ || axisalignedbb.minZ >= this.maxZ) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxX <= this.minX && (d1 = this.minX - axisalignedbb.maxX) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minX >= this.maxX && (d2 = this.maxX - axisalignedbb.minX) > d) {
            d = d2;
        }
        return d;
    }

    public double calculateYOffset(AABB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return d;
        }
        if (axisalignedbb.maxZ <= this.minZ || axisalignedbb.minZ >= this.maxZ) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxY <= this.minY && (d1 = this.minY - axisalignedbb.maxY) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minY >= this.maxY && (d2 = this.maxY - axisalignedbb.minY) > d) {
            d = d2;
        }
        return d;
    }

    public double calculateZOffset(AABB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return d;
        }
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxZ <= this.minZ && (d1 = this.minZ - axisalignedbb.maxZ) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minZ >= this.maxZ && (d2 = this.maxZ - axisalignedbb.minZ) > d) {
            d = d2;
        }
        return d;
    }

    public boolean intersectsWith(AABB axisalignedbb) {
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return false;
        }
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return false;
        }
        return axisalignedbb.maxZ > this.minZ && axisalignedbb.minZ < this.maxZ;
    }

    public AABB offset(double d, double d1, double d2) {
        this.minX += d;
        this.minY += d1;
        this.minZ += d2;
        this.maxX += d;
        this.maxY += d1;
        this.maxZ += d2;
        return this;
    }

    public boolean isVecInside(Vec3d vec3d) {
        if (vec3d.xCoord <= this.minX || vec3d.xCoord >= this.maxX) {
            return false;
        }
        if (vec3d.yCoord <= this.minY || vec3d.yCoord >= this.maxY) {
            return false;
        }
        return vec3d.zCoord > this.minZ && vec3d.zCoord < this.maxZ;
    }

    public double getAverageEdgeLength() {
        double d = this.maxX - this.minX;
        double d1 = this.maxY - this.minY;
        double d2 = this.maxZ - this.minZ;
        return (d + d1 + d2) / 3.0;
    }

    public AABB getInsetBoundingBox(double d, double d1, double d2) {
        double d3 = this.minX + d;
        double d4 = this.minY + d1;
        double d5 = this.minZ + d2;
        double d6 = this.maxX - d;
        double d7 = this.maxY - d1;
        double d8 = this.maxZ - d2;
        return AABB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AABB copy() {
        return AABB.getBoundingBoxFromPool(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public HitResult func_1169_a(Vec3d start, Vec3d end) {
        Vec3d vec3d2 = start.getIntermediateWithXValue(end, this.minX);
        Vec3d vec3d3 = start.getIntermediateWithXValue(end, this.maxX);
        Vec3d vec3d4 = start.getIntermediateWithYValue(end, this.minY);
        Vec3d vec3d5 = start.getIntermediateWithYValue(end, this.maxY);
        Vec3d vec3d6 = start.getIntermediateWithZValue(end, this.minZ);
        Vec3d vec3d7 = start.getIntermediateWithZValue(end, this.maxZ);
        if (!this.isVecInYZ(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInYZ(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInXZ(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInXZ(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInXY(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInXY(vec3d7)) {
            vec3d7 = null;
        }
        Vec3d vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || start.squareDistanceTo(vec3d2) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || start.squareDistanceTo(vec3d3) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || start.squareDistanceTo(vec3d4) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || start.squareDistanceTo(vec3d5) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || start.squareDistanceTo(vec3d6) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || start.squareDistanceTo(vec3d7) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        Side side = Side.NONE;
        if (vec3d8 == vec3d2) {
            side = Side.WEST;
        }
        if (vec3d8 == vec3d3) {
            side = Side.EAST;
        }
        if (vec3d8 == vec3d4) {
            side = Side.BOTTOM;
        }
        if (vec3d8 == vec3d5) {
            side = Side.TOP;
        }
        if (vec3d8 == vec3d6) {
            side = Side.NORTH;
        }
        if (vec3d8 == vec3d7) {
            side = Side.SOUTH;
        }
        return new HitResult(0, 0, 0, side, vec3d8);
    }

    private boolean isVecInYZ(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInXZ(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInXY(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void setBB(AABB axisalignedbb) {
        this.minX = axisalignedbb.minX;
        this.minY = axisalignedbb.minY;
        this.minZ = axisalignedbb.minZ;
        this.maxX = axisalignedbb.maxX;
        this.maxY = axisalignedbb.maxY;
        this.maxZ = axisalignedbb.maxZ;
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }
}

