/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.noise.PerlinNoise;

public class DensityGeneratorNether
implements DensityGenerator {
    private final World world;
    private final PerlinNoise minLimitNoise;
    private final PerlinNoise maxLimitNoise;
    private final PerlinNoise mainNoise;
    private final PerlinNoise scaleNoise;
    private final PerlinNoise depthNoise;

    public DensityGeneratorNether(World world) {
        this.world = world;
        this.minLimitNoise = new PerlinNoise(world.getRandomSeed(), 16, 0);
        this.maxLimitNoise = new PerlinNoise(world.getRandomSeed(), 16, 16);
        this.mainNoise = new PerlinNoise(world.getRandomSeed(), 8, 32);
        this.scaleNoise = new PerlinNoise(world.getRandomSeed(), 10, 48);
        this.depthNoise = new PerlinNoise(world.getRandomSeed(), 16, 58);
    }

    @Override
    public double[] generateDensityMap(Chunk chunk) {
        int terrainHeight = this.world.getWorldType().getMaxY() + 1 - this.world.getWorldType().getMinY();
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunk.xPosition * 4;
        boolean y = false;
        int z = chunk.zPosition * 4;
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 60.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 1.0;
        double scaleNoiseScaleZ = 1.0;
        double depthNoiseScaleX = 100.0;
        double depthNoiseScaleZ = 100.0;
        double depthBaseSize = (double)terrainHeight / 16.0 + 0.5;
        double coordScale = 684.412;
        double heightScale = 2053.236;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double[] scaleArray = this.scaleNoise.get(null, x, z, xSize, zSize, 1.0, 1.0);
        double[] depthArray = this.depthNoise.get(null, x, z, xSize, zSize, 100.0, 100.0);
        double[] mainNoiseArray = this.mainNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 8.555150000000001, 34.2206, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        double[] densityOffsetArray = new double[ySize];
        for (int dy = 0; dy < ySize; ++dy) {
            densityOffsetArray[dy] = Math.cos((double)dy * Math.PI * 6.0 / (double)ySize) * 2.0;
            double densityOffset = dy;
            if (dy > ySize / 2) {
                densityOffset = ySize - 1 - dy;
            }
            if (!(densityOffset < 4.0)) continue;
            densityOffset = 4.0 - densityOffset;
            int n = dy;
            densityOffsetArray[n] = densityOffsetArray[n] - densityOffset * densityOffset * densityOffset * 10.0;
        }
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 512.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                double d4 = 0.0;
                double depth = depthArray[depthScaleIndex] / 8000.0;
                if (depth < 0.0) {
                    depth = -depth;
                }
                if ((depth = depth * 3.0 - 3.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 6.0;
                }
                scale += 0.5;
                depth = depth * (depthBaseSize * 2.0) / 16.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = densityOffsetArray[dy];
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy > ySize - 4) {
                        double d11 = (float)(dy - (ySize - 4)) / 3.0f;
                        density = density * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)dy < d4) {
                        double densityMod = (d4 - (double)dy) / 4.0;
                        if (densityMod < 0.0) {
                            densityMod = 0.0;
                        }
                        if (densityMod > 1.0) {
                            densityMod = 1.0;
                        }
                        density = density * (1.0 - densityMod) + -10.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }
}

