/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityReddustFX
extends EntityFX {
    float originalScale;
    private int brightness = -1;

    public EntityReddustFX(World world, double x, double y, double z, float red, float green, float blue, int brightness) {
        this(world, x, y, z, 1.0f, red, green, blue, brightness);
    }

    public EntityReddustFX(World world, double x, double y, double z, float scale, float red, float green, float blue, int brightness) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        if (brightness >= 0) {
            this.brightness = brightness;
        }
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        float f4 = (float)Math.random() * 0.4f + 0.6f;
        this.particleRed = ((float)(Math.random() * 0.2) + 0.8f) * red * f4;
        this.particleGreen = ((float)(Math.random() * 0.2) + 0.8f) * green * f4;
        this.particleBlue = ((float)(Math.random() * 0.2) + 0.8f) * blue * f4;
        this.particleScale *= 0.75f;
        this.particleScale *= scale;
        this.originalScale = this.particleScale;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * scale);
        this.noPhysics = false;
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + partialTick) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.originalScale * f6;
        if (this.particleTexture == null) {
            return;
        }
        float texMinU = (float)this.particleTexture.getIconUMin();
        float texMaxU = (float)this.particleTexture.getSubIconU(1.0);
        float texMinV = (float)this.particleTexture.getIconVMin();
        float texMaxV = (float)this.particleTexture.getSubIconV(1.0);
        float scale = 0.1f * this.particleScale;
        float posX = (float)(this.xo + (this.x - this.xo) * (double)partialTick - lerpPosX);
        float posY = (float)(this.yo + (this.y - this.yo) * (double)partialTick - lerpPosY);
        float posZ = (float)(this.zo + (this.z - this.zo) * (double)partialTick - lerpPosZ);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int blockX = MathHelper.floor_double(this.x);
            int blockY = MathHelper.floor_double(this.y);
            int blockZ = MathHelper.floor_double(this.z);
            int lmc = this.brightness >= 0 ? LightmapHelper.getLightmapCoord(this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ), Math.max(this.world.getSavedLightValue(LightLayer.Block, blockX, blockY, blockZ), this.brightness)) : this.getLightmapCoord(partialTick);
            t.setLightmapCoord(lmc);
        } else {
            brightness = Math.max(this.getBrightness(partialTick), (float)this.brightness / 15.0f);
        }
        t.setColorOpaque_F(this.particleRed * brightness, this.particleGreen * brightness, this.particleBlue * brightness);
        t.addVertexWithUV(posX - rotationX * scale - rotationYZ * scale, posY - rotationXZ * scale, posZ - rotationZ * scale - rotationXY * scale, texMaxU, texMaxV);
        t.addVertexWithUV(posX - rotationX * scale + rotationYZ * scale, posY + rotationXZ * scale, posZ - rotationZ * scale + rotationXY * scale, texMaxU, texMinV);
        t.addVertexWithUV(posX + rotationX * scale + rotationYZ * scale, posY + rotationXZ * scale, posZ + rotationZ * scale + rotationXY * scale, texMinU, texMinV);
        t.addVertexWithUV(posX + rotationX * scale - rotationYZ * scale, posY - rotationXZ * scale, posZ + rotationZ * scale - rotationXY * scale, texMinU, texMaxV);
    }

    @Override
    public void tick() {
        int val;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.particleTexture = (val = 7 - this.particleAge * 8 / this.particleMaxAge) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

