/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.item.Item;
import net.minecraft.core.world.World;

public class EntitySlimeChunkFX
extends EntityFX {
    public EntitySlimeChunkFX(World world, double d, double d1, double d2, Item item) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleTexture = ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack());
        this.particleGravity = 2.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale /= 2.0f;
        this.particleMaxAge = 50;
    }

    @Override
    public int getFXLayer() {
        return 2;
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = (float)this.particleTexture.getSubIconU(this.particleTextureJitterX / 4.0f);
        float f7 = (float)this.particleTexture.getSubIconU(0.25f + this.particleTextureJitterX / 4.0f);
        float f8 = (float)this.particleTexture.getSubIconV(this.particleTextureJitterX / 4.0f);
        float f9 = (float)this.particleTexture.getSubIconV(0.25f + this.particleTextureJitterX / 4.0f);
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)partialTick - lerpPosX);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)partialTick - lerpPosY);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)partialTick - lerpPosZ);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            brightness = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(brightness * this.particleRed, brightness * this.particleGreen, brightness * this.particleBlue);
        t.addVertexWithUV(f11 - rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 - rotationZ * f10 - rotationXY * f10, f6, f9);
        t.addVertexWithUV(f11 - rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 - rotationZ * f10 + rotationXY * f10, f6, f8);
        t.addVertexWithUV(f11 + rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 + rotationZ * f10 + rotationXY * f10, f7, f8);
        t.addVertexWithUV(f11 + rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 + rotationZ * f10 - rotationXY * f10, f7, f9);
    }
}

