/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.option.ToggleableOption;
import net.minecraft.client.render.FontRenderer;
import org.lwjgl.opengl.GL11;

public class GuiSliderInteger
extends GuiButton {
    public int sliderValue;
    public boolean dragging = false;
    private ToggleableOption<?> option;

    public GuiSliderInteger(int id, int xPosition, int yPosition, ToggleableOption<?> option) {
        this(id, xPosition, yPosition, 150, 20, option);
    }

    public GuiSliderInteger(int id, int xPosition, int yPosition, int width, int height, ToggleableOption<?> option) {
        super(id, xPosition, yPosition, width, height, option.getDisplayStringValue());
        this.option = option;
        this.sliderValue = option.getValueIndex();
        this.displayString = option.getDisplayStringValue();
    }

    private int getSliderWidth() {
        return 8;
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        int sliderWidth = this.getSliderWidth();
        int maxValue = this.option.size() - 1;
        if (this.dragging) {
            int segments = maxValue;
            float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - sliderWidth);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.fontRenderer;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46, this.width / 2, this.height);
        int sliderWidth = this.getSliderWidth();
        int maxValue = this.option.size() - 1;
        this.drawTexturedModalRect(this.xPosition + (int)((float)this.sliderValue / (float)maxValue * (float)(this.width - sliderWidth)), this.yPosition, 0, 46 + state * 20, sliderWidth / 2, 20);
        this.drawTexturedModalRect(this.xPosition + (int)((float)this.sliderValue / (float)maxValue * (float)(this.width - sliderWidth)) + sliderWidth / 2, this.yPosition, 200 - sliderWidth / 2, 46 + state * 20, sliderWidth / 2, 20);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        if (super.mouseClicked(mc, mouseX, mouseY)) {
            int segments = this.option.size() - 1;
            float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - 8);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
        this.displayString = this.option.getDisplayString();
    }
}

