/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.hud.ComponentAnchor;
import net.minecraft.client.gui.hud.HudComponent;
import net.minecraft.client.gui.hud.HudComponents;
import net.minecraft.client.gui.hud.Layout;

public class SnapLayout
extends Layout {
    private HudComponent parent;
    private ComponentAnchor parentAnchor;
    private ComponentAnchor anchor;

    public SnapLayout(HudComponent parent, ComponentAnchor parentAnchor, ComponentAnchor anchor) {
        this.parent = parent;
        this.parentAnchor = parentAnchor;
        this.anchor = anchor;
    }

    public HudComponent getParent() {
        return this.parent;
    }

    public ComponentAnchor getParentAnchor() {
        return this.parentAnchor;
    }

    public ComponentAnchor getAnchor() {
        return this.anchor;
    }

    public void setParent(HudComponent parent) {
        this.parent = parent;
    }

    public void setParentAnchor(ComponentAnchor parentAnchor) {
        this.parentAnchor = parentAnchor;
    }

    public void setAnchor(ComponentAnchor anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getComponentX(Minecraft mc, HudComponent component, int xSizeScreen) {
        if (this.parent == null) {
            int sp = (int)(((Float)mc.gameSettings.screenPadding.value).floatValue() * (float)mc.resolution.scaledHeight / 8.0f);
            return (int)((float)xSizeScreen * this.parentAnchor.xPosition) - component.getAnchorX(this.anchor) + sp;
        }
        return this.parent.getLayout().getComponentX(mc, this.parent, xSizeScreen) - component.getAnchorX(this.anchor) + this.parent.getAnchorX(this.parentAnchor);
    }

    @Override
    public int getComponentY(Minecraft mc, HudComponent component, int ySizeScreen) {
        if (this.parent == null) {
            int sp = (int)(((Float)mc.gameSettings.screenPadding.value).floatValue() * (float)mc.resolution.scaledHeight / 8.0f);
            return (int)((float)ySizeScreen * this.parentAnchor.yPosition) - component.getAnchorY(this.anchor) + sp;
        }
        return this.parent.getLayout().getComponentY(mc, this.parent, ySizeScreen) - component.getAnchorY(this.anchor) + this.parent.getAnchorY(this.parentAnchor);
    }

    @Override
    public Layout copy() {
        return new SnapLayout(this.parent, this.parentAnchor, this.anchor);
    }

    @Override
    public String toSettingsString() {
        return (this.parent == null ? "null" : this.parent.getKey()) + "," + this.parentAnchor.name() + "," + this.anchor.name();
    }

    @Override
    public void fromSettingsString(String settings) {
        String[] parts = settings.split(",");
        this.parent = parts[0].equals("null") ? null : HudComponents.INSTANCE.getComponent(parts[0]);
        this.parentAnchor = ComponentAnchor.valueOf(parts[1]);
        this.anchor = ComponentAnchor.valueOf(parts[2]);
    }
}

