/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerButton;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public class EntityBoatEntry
extends EntityEntry<EntityBoat> {
    @Override
    public void onTick(EntityBoat entity) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, EntityBoat entity) {
        final GuiListenerButton flagButton = new GuiListenerButton(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.boat.button.flag", false));
        flagButton.setActionListener(() -> {
            boolean flag;
            if (entity.tileEntityFlag == null) {
                entity.tileEntityFlag = new TileEntityFlag();
                flag = true;
            } else {
                entity.tileEntityFlag = null;
                flag = false;
            }
            flagButton.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.boat.button.flag", flag);
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(flagButton);
            }
        };
    }

    @Override
    public EntityBoat getEntityInstance(Minecraft mc, World world) {
        EntityBoat boat = new EntityBoat(world);
        boat.yRot = 270.0f;
        boat.zd = 100.0;
        return boat;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

