/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityDiggingFX;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.GenericFXEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListSelectorButton;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockFXEntry
extends GenericFXEntry {
    protected int blockId;
    protected int meta;
    private Side side = Side.BOTTOM;

    public BlockFXEntry() {
        super("block");
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen) {
        List<GuiButton> buttonList = super.getEntryButtons(mc, parentScreen);
        GuiTextCycle<Integer> blockIdCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, buttonList.get(buttonList.size() - 1).getY() + 21, 120, 20, Integer.valueOf(this.blockId)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return GuiModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return BlockFXEntry.this.blockId;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        blockIdCycle.textField.setPrefaceText("ID: ");
        blockIdCycle.textField.setPlaceholder("Block ID");
        blockIdCycle.setOnValueChanged(() -> {
            this.blockId = (Integer)blockIdCycle.getCurrentElement();
        });
        buttonList.add(blockIdCycle);
        GuiTextCycle<Integer> metaCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, blockIdCycle.getY() + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    return BlockFXEntry.this.meta;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        metaCycle.setOnValueChanged(() -> {
            this.meta = (Integer)metaCycle.getCurrentElement();
        });
        buttonList.add(metaCycle);
        GuiListSelectorButton<Side> sideButton = new GuiListSelectorButton<Side>(-1, -120, metaCycle.getY() + 21, 120, 20, I18n.getInstance().translateKey("model.category.particle.block.side"), Arrays.asList(Side.sides), this.side){

            @Override
            public String getNameFromElement(Side element) {
                return element.name();
            }
        };
        sideButton.setOnValueChanged(() -> {
            this.side = (Side)((Object)((Object)sideButton.getCurrentElement()));
        });
        buttonList.add(sideButton);
        return buttonList;
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.effectRenderer.addEffect(new EntityDiggingFX(world, x, y, z, this.motionX, this.motionY, this.motionZ, Block.getBlock(this.blockId), this.side.getId(), this.meta));
    }

    @Override
    public void onOpen() {
        this.blockId = 1;
    }
}

